<?php $__env->startSection('content'); ?>
    <div class="page-content">
        <div class="row">
            <div class="col-md-12">

                <div class="card">
                    <div class="card-header bg-white d-flex justify-content-between align-items-center">
                        <form class=" d-flex align-items-end   gap-3" id="status">
                            <div class="d-flex flex-column gap-1">
                                <span class="mb-0 text-nowrap ">Filter By Status</span>
                           <select name="status" class="form-select form-select-sm"
        onchange="this.form.submit()" style="min-width: 150px">
    <option value="" <?php echo e(request()->status === null ? 'selected' : ''); ?>>All</option>
    <option value="draft" <?php echo e(request()->status === 'draft' ? 'selected' : ''); ?>>Draft</option>
    <option value="published" <?php echo e(request()->status === 'published' ? 'selected' : ''); ?>>Published</option>
    <option value="paused" <?php echo e(request()->status === 'paused' ? 'selected' : ''); ?>>Paused</option>
    <option value="inactive" <?php echo e(request()->status === 'inactive' ? 'selected' : ''); ?>>Inactive</option>
</select>

                            </div>
                            <a href="<?php echo e(route('admin.course.index')); ?>" class="btn btn-primary btn-sm">Reset</a>

                        </form>
                        <div>
                            <a href="<?php echo e(route('admin.course.create')); ?>" class="btn btn-success btn-sm">
                                <i class="bi bi-plus-circle me-1"></i> Add New course
                            </a>
                        </div>

                    </div>


                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped my-table2 dataTable no-footer" id="datatable_internal">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>#</th>
                                        <th style="max-width: 250px">Title</th>
                                        <th>Thumbnail</th>
                                        <th>Price</th>
                                        <th>Info </th>
                                        <th>Status</th>
                                        <th>Is Home</th>
                                        <th>Action</th>
                                    </tr>

                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="partenTr_<?php echo e($course->id); ?>">
                                            <td><?php echo e($loop->iteration); ?></td>
                                            <td style="max-width: 230px" class="text-wrap"><?php echo e($course->title); ?>

                                                <br>
                                                <span class="badge btn-emerald"><?php echo e($course->category->name ?? '-'); ?></span>
                                            </td>
                                              <td>
                                                <img src="<?php echo e(asset($course->thumbnail_url)); ?>" alt="thumbnail"
                                                    class="img-thumbnail" style="width:45px; height:45px;">
                                            </td>
                                          
                                            <td>
                                                <?php if($course->discounted_price > 0): ?>
                                                    <del>৳<?php echo e($course->original_price); ?></del>
                                                    <b>৳<?php echo e($course->discounted_price); ?></b>
                                                <?php else: ?>
                                                    <b> ৳<?php echo e($course->original_price); ?></b>
                                                <?php endif; ?>
                                            </td>

                                            <td>
                                                <?php if($course->course_type == 'Live'): ?>
                                                    <span
                                                        class="badge border-0 btn-danger-light"><?php echo e($course->course_type); ?></span>
                                                <?php else: ?>
                                                    <span
                                                        class="badge border-0 btn-purple"><?php echo e($course->course_type); ?></span>
                                                <?php endif; ?>
                                                <span class="badge border-0 btn-info"> <?php echo e($course->total_enroll); ?>

                                                    Enrolled</span>

                                                <?php if($course->is_free): ?>
                                                    <span class="badge border-0 btn-emerald"> Free</span>
                                                <?php else: ?>
                                                    <span class="badge border-0 btn-pink"> Paid</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <select class="form-select form-select-sm status-select updateStatus"
                                                    id="status" name="status" data-id="<?php echo e($course->id); ?>" data-current="<?php echo e($course->status); ?>"
                                                    style="
                <?php if($course->status == 'draft'): ?> background-color: rgb(243, 244, 246); color: rgb(107, 114, 128);
                <?php elseif($course->status == 'published'): ?> background-color: rgb(236, 253, 245); color: rgb(22, 101, 52);
                <?php elseif($course->status == 'paused'): ?> background-color: rgb(255, 251, 235); color: rgb(161, 98, 7);
                <?php elseif($course->status == 'inactive'): ?> background-color: rgb(255, 241, 231); color: rgb(197, 78, 0); <?php endif; ?> ">
                                                    <option value="draft"
                                                        style="background-color: #F3F4F6; color: #6B7280;"
                                                        <?php echo e($course->status == 'draft' ? 'selected' : ''); ?>>Draft</option>
                                                    <option value="published"
                                                        style="background-color: #ECFDF5; color: #166534;"
                                                        <?php echo e($course->status == 'published' ? 'selected' : ''); ?>>Published
                                                    </option>
                                                    <option value="paused"
                                                        style="background-color: #FFFBEB; color: #A16207;"
                                                        <?php echo e($course->status == 'paused' ? 'selected' : ''); ?>>Paused</option>
                                                    <option value="inactive"
                                                        style="background-color: #FFF1E7; color: #C54E00;"
                                                        <?php echo e($course->status == 'inactive' ? 'selected' : ''); ?>>Inactive
                                                    </option>
                                                </select>
                                            </td>


                                            <td>
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input me-2 switchPopular" type="checkbox"
                                                        id="switchPopular" name="is_home" value="1"
                                                        data-id="<?php echo e($course->id); ?>"
                                                        <?php echo e(old('is_home', $course->is_home) ? 'checked' : ''); ?>

                                                        style="width:44px;height:22px;cursor:pointer">
                                                    <label class="form-check-label" for="switchPopular"></label>
                                                    <?php $__errorArgs = ['is_home'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </td>

                        </div>
                        <td>
                            <a href="<?php echo e(route('admin.course.show',$course->id)); ?>" class="">
                  <button type="button" class="btn btn-sm btn-info" style="background-color: #a3ffed91;border-color: #a3ffed91;">
                                                                       <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-eye  hover:scale-105 dark:text-primary-400"><path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"></path><circle cx="12" cy="12" r="3"></circle></svg>
                                                                    </button>
                </a>
                            <a href="<?php echo e(route('admin.course.edit', $course->id)); ?>" class="col">
                                <button type="button" class="btn btn-primary btn-sm">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                        fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                        <path
                                            d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z">
                                        </path>
                                        <path fill-rule="evenodd"
                                            d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z">
                                        </path>
                                    </svg>
                                </button>
                            </a>

                            <a href="javascript:void(0)" class="btn btn-danger btn-sm deleteButton"
                                data-parentid="partenTr_<?php echo e($course->id); ?>"
                                data-url=<?php echo e(route('admin.course.delete', $course->id)); ?>>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                    class="bi bi-trash3-fill" viewBox="0 0 16 16">
                                    <path
                                        d="M11 1.5v1h3.5a.5.5 0 0 1 0 1h-.538l-.853 10.66A2 2 0 0 1 11.115 16h-6.23a2 2 0 0 1-1.994-1.84L2.038 3.5H1.5a.5.5 0 0 1 0-1H5v-1A1.5 1.5 0 0 1 6.5 0h3A1.5 1.5 0 0 1 11 1.5m-5 0v1h4v-1a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5M4.5 5.029l.5 8.5a.5.5 0 1 0 .998-.06l-.5-8.5a.5.5 0 1 0-.998.06m6.53-.528a.5.5 0 0 0-.528.47l-.5 8.5a.5.5 0 0 0 .998.058l.5-8.5a.5.5 0 0 0-.47-.528M8 4.5a.5.5 0 0 0-.5.5v8.5a.5.5 0 0 0 1 0V5a.5.5 0 0 0-.5-.5">
                                    </path>
                                </svg>
                            </a>
                        </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
    </div>


    <?php $__env->startPush('js'); ?>
        <script>
            $(document).ready(function() {
                $('.switchPopular').click(function(e) {

                    var checkbox = $(this);
                    var id = checkbox.data('id');
                    var isCheck = checkbox.prop('checked');

                    Swal.fire({
                        title: isCheck ? 'Are you sure you want to mark this course as Popular?' :
                            'Are you sure you want to remove from Popular?',
                        icon: 'question',
                        showCancelButton: true,
                        confirmButtonText: 'Yes',
                        cancelButtonText: 'No'
                    }).then((result) => {

                        if (result.isConfirmed) {
                            // Confirm করলে loader দেখাবে
                            Swal.fire({
                                title: 'Updating...',
                                text: 'Please wait while the status is being updated.',
                                allowOutsideClick: false,
                                didOpen: () => {
                                    Swal.showLoading();
                                }
                            });

                            $.ajax({
                                url: "<?php echo e(route('admin.course.update-is_home')); ?>",
                                method: 'PATCH',
                                data: {
                                    _token: "<?php echo e(csrf_token()); ?>",
                                    id: id,
                                    status: isCheck ? '1' : '0'
                                },
                                success: function(response) {
                                    Swal.close();
                                    if (response.status) {
                                        Swal.fire({
                                            icon: 'success',
                                            title: 'Success!',
                                            text: response.message,
                                            timer: 3000,
                                            showConfirmButton: true
                                        });
                                        checkbox.prop('checked', isCheck);

                                    }
                                },
                                error: function(xhr) {
                                    Swal.close();
                                    checkbox.prop('checked', !isCheck);
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Error!',
                                        text: xhr.responseJSON?.message ||
                                            'Something Went Wrong'
                                    });
                                }
                            });


                        } else {
                            checkbox.prop('checked', !isCheck);
                        }
                    });
                });
            });

            $('.updateStatus').on('change', function() {
                var status = this.value; 
                var element = $(this)
                var id = element.data('id');
                var el = this;

                // Define status label and color
                var statusLabels = {
                    'draft': {
                        text: 'Draft',
                        color: 'rgb(107, 114, 128)'
                    },
                    'published': {
                        text: 'Published',
                        color: 'rgb(22, 101, 52)'
                    },
                    'paused': {
                        text: 'Paused',
                        color: 'rgb(161, 98, 7)'
                    },
                    'inactive': {
                        text: 'Inactive',
                        color: 'rgb(197, 78, 0)'
                    }
                };

                Swal.fire({
                    title: 'Are you sure?',
                    html: 'This action will update the status to <strong style="color:' + statusLabels[status]
                        .color + '">' + statusLabels[status].text + '</strong>.',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, update it!',
                    cancelButtonText: 'No, cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        Swal.fire({
                            title: 'Updating...',
                            text: 'Please wait while the status is being updated.',
                            allowOutsideClick: false,
                            didOpen: () => {
                                Swal.showLoading();
                            }
                        });

                        $.ajax({
                            url: "<?php echo e(route('admin.course.update-status')); ?>",
                            method: 'PATCH',
                            data: {
                                _token: "<?php echo e(csrf_token()); ?>",
                                id: id,
                                status: status
                            },
                            success: function(response) {
                                Swal.close();
                                if (response.status) {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Success!',
                                        text: response.message,
                                        timer: 4000,
                                        showConfirmButton: true
                                    });

                                    // Update dropdown color dynamically
                                    el.style.backgroundColor = statusLabels[status].color +
                                    '33'; // light shade
                                    el.style.color = statusLabels[status].color;
                                    element.data('current', status);
                                }
                            },
                            error: function(xhr) {
                                Swal.close();
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error!',
                                    text: xhr.responseJSON?.message ||
                                        'Something Went Wrong'
                                });
                            }
                        });
                    } else {
                        el.value = element.data('current');
                    }
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nexgenweb/lms.nexgenwebhub.com/resources/views/backend/page/course/index.blade.php ENDPATH**/ ?>