<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title', $seoSetting->site_title ?? $websiteSetting->app_name); ?></title>

    <meta name="robots" content="<?php echo $__env->yieldContent('robots', $seoSetting->meta_robots ?? 'index, follow'); ?>" />
    <meta name="google-site-verification" content="<?php echo $__env->yieldContent('google_verification', $seoSetting->google_verification ?? ''); ?>" />

    <meta name="description" content="<?php echo $__env->yieldContent('description', $seoSetting->meta_description ?? 'Default description here'); ?>">
    <meta name="keywords" content="<?php echo $__env->yieldContent('keyword', $seoSetting->meta_keywords ?? ''); ?>">
    <meta name="author" content="<?php echo $__env->yieldContent('author', $seoSetting->meta_author ?? 'Admin'); ?>">

    <meta property="og:locale" content="en_US" />
    <meta property="og:title" content="<?php echo $__env->yieldContent('title', $seoSetting->site_title ?? $websiteSetting->app_name); ?>">
    <meta property="og:description" content="<?php echo $__env->yieldContent('description', $seoSetting->meta_description); ?>">
    <meta property="og:image" content="<?php echo $__env->yieldContent('image', asset($websiteSetting->logo)); ?>">
    <meta property="og:url" content="<?php echo $__env->yieldContent('url', url()->current()); ?>">
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="<?php echo $__env->yieldContent('title', $seoSetting->site_title ?? $websiteSetting->app_name); ?>">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo $__env->yieldContent('title', $seoSetting->site_title ?? $websiteSetting->app_name); ?>">
    <meta name="twitter:description" content="<?php echo $__env->yieldContent('description', $seoSetting->meta_description ?? 'Learn from our expert-led courses to enhance your skills and knowledge.'); ?>">
    <meta name="twitter:image" content="<?php echo $__env->yieldContent('image', asset($websiteSetting->logo)); ?>">
    <meta name="twitter:site" content="<?php echo $__env->yieldContent('twitter', '@YourTwitterHandle'); ?>">

    <link rel="icon" type="image/x-icon" href="<?php echo e(asset($websiteSetting->favicon)); ?>">
    <link href="<?php echo e(asset('assets/css/tom-select.css')); ?>" rel="stylesheet">
    <script src="<?php echo e(asset('assets/js/tom-select.complete.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/packge-j.js')); ?>"></script>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/slider.css')); ?>" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css"
        integrity="sha512-2SwdPD6INVrV/lHTZbO2nodKhrnDdJK9/kg2XD1r9uGqPo1cUbujc+IYdlYdEErWNu69gVcYgdxlmVmzTWnetw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="<?php echo e(asset('assets/js/slider.js')); ?>"></script>

    <link rel="stylesheet" href="<?php echo e(asset('assets/css/ivis_toast.css')); ?>">
    <script src="<?php echo e(asset('assets/js/ivis_toast.js')); ?>"></script>

    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <?php if(session('swl')): ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/sweetalert2.min.css')); ?>">
    <?php endif; ?>
    <?php echo $__env->yieldPushContent('css'); ?>
    <?php echo app('Illuminate\Foundation\Vite')('resources/css/app.css'); ?>
    <style>
        @keyframes float {

            0%,
            100% {
                transform: translateY(0px);
            }

            50% {
                transform: translateY(-10px);
            }
        }

        .animate-float {
            animation: float 3s ease-in-out infinite;
        }
    </style>
</head>

<body class="min-h-screen bg-gray-50">

    <?php ($hideLayout = $hideLayout ?? false); ?>

    <?php if(!$hideLayout): ?>
        <header class="modern-header">
            <div class="header-container bg-custom-secondary">
                <div class="flex items-center justify-between h-16 bg-custom-secondary">
                    <!-- Logo and Mobile Menu Button -->
                    <div class="flex items-center gap-4">
                        <button class="mobile-menu-button" id="mobileMenuButton">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                                stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M4 6h16M4 12h16M4 18h16" />
                            </svg>
                        </button>
                        <a href="/" class="flex items-center">
                            <img alt="Logo" class="h-14 w-auto" src="<?php echo e(asset($websiteSetting->logo)); ?>">
                        </a>
                    </div>

                    <!-- Desktop Navigation -->
                    <nav class="nav-menu hidden md:flex">
                        <a href="/"
                            class="nav-link <?php echo e(request()->is('/') ? 'active' : ''); ?>"><?php echo e(__('menu.home')); ?></a>
                        <a href="/courses"
                            class="nav-link <?php echo e(request()->is('courses*') ? 'active' : ''); ?>"><?php echo e(__('menu.course')); ?></a>
                        <a href="/about-us"
                            class="nav-link <?php echo e(request()->is('about') ? 'active' : ''); ?>"><?php echo e(__('menu.about_us')); ?></a>
                        <a href="/blogs"
                            class="nav-link <?php echo e(request()->is('contact') ? 'active' : ''); ?>"><?php echo e(__('menu.blog')); ?></a>
                    </nav>

                    <!-- Header Actions -->
                    <div class="flex items-center gap-3 header-actions">
                        <!-- Language Switcher -->
                        

                        <?php if(auth()->guard()->check()): ?>
                            <!-- Notifications -->
                            <?php if(Auth::user()->role == 1 || Auth::user()->role == 4): ?>
                                <div class="notification-container">
                                    <button class="notification-button" id="notificationButton">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20"
                                            fill="currentColor">
                                            <path
                                                d="M10 2a6 6 0 00-6 6v3.586l-.707.707A1 1 0 004 14h12a1 1 0 00.707-1.707L16 11.586V8a6 6 0 00-6-6zM10 18a3 3 0 01-3-3h6a3 3 0 01-3 3z" />
                                        </svg>
                                        <?php if($totalNotifications > 0): ?>
                                            <span class="notification-badge"><?php echo e($totalNotifications); ?></span>
                                        <?php endif; ?>
                                    </button>
                                    <div class="notification-dropdown hidden" id="notificationDropdown">
                                        <div class="notification-header">
                                            <h3 class="notification-title">Notifications</h3>
                                            <?php if($totalNotifications > 0): ?>
                                                <span class="notification-count"><?php echo e(round($totalNotifications / 2)); ?>

                                                    New</span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="notification-list">
                                            <?php $__empty_1 = true; $__currentLoopData = $top_notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $top_notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <a href="<?php echo e(route('dashboard.notification.view', $top_notification->id)); ?>"
                                                    class="notification-item">
                                                    <div class="notification-icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5"
                                                            viewBox="0 0 20 20" fill="currentColor">
                                                            <path d="M10 12a2 2 0 100-4 2 2 0 000 4z" />
                                                            <path fill-rule="evenodd"
                                                                d="M.458 10C1.732 5.943 5.522 3 10 3s8.268 2.943 9.542 7c-1.274 4.057-5.064 7-9.542 7S1.732 14.057.458 10zM14 10a4 4 0 11-8 0 4 4 0 018 0z"
                                                                clip-rule="evenodd" />
                                                        </svg>
                                                    </div>
                                                    <div class="notification-content">
                                                        <div class="notification-message"><?php echo e($top_notification->title); ?>

                                                        </div>
                                                        <div class="notification-text"><?php echo $top_notification->message; ?></div>
                                                        <div class="notification-time">
                                                            <?php echo e($top_notification->created_at->diffForHumans()); ?></div>
                                                    </div>
                                                </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <div class="notification-item">
                                                    <div class="notification-content">
                                                        <div class="notification-message">No notifications</div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="notification-footer">
                                            <a href="<?php echo e(route('dashboard.notification')); ?>"
                                                class="notification-link">View All Notifications</a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- User Dropdown -->
                            <div class="user-dropdown">
                                <button class="user-button" id="userButton">
                                    <img src="<?php echo e(Auth::user()->image ?? asset('assets/icons/user-1.png')); ?>"
                                        alt="User" class="user-avatar">
                                    <span class="user-name"><?php echo e(Auth::user()->name); ?></span>
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20"
                                        fill="currentColor">
                                        <path fill-rule="evenodd"
                                            d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                            clip-rule="evenodd" />
                                    </svg>
                                </button>
                                <div class="user-dropdown-menu hidden" id="userDropdown">
                                    
                                    
                                    <a href="<?php echo e(route('dashboard')); ?>" class="user-dropdown-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="user-dropdown-icon" fill="none"
                                            viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                                        </svg>
                                        <span class="user-dropdown-text"><?php echo e(__('menu.dashboard')); ?></span>
                                    </a>
                                    <a href="<?php echo e(route('dashboard.my-course')); ?>" class="user-dropdown-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="user-dropdown-icon" fill="none"
                                            viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253" />
                                        </svg>
                                        <span class="user-dropdown-text"><?php echo e(__('menu.my_courses')); ?></span>
                                    </a>
                                    <a href="<?php echo e(route('dashboard.enrollment')); ?>" class="user-dropdown-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="user-dropdown-icon" fill="none"
                                            viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
                                        </svg>
                                        <span class="user-dropdown-text"><?php echo e(__('menu.enrollment_history')); ?></span>
                                    </a>
                                    <a href="<?php echo e(route('dashboard.save-videos')); ?>" class="user-dropdown-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="user-dropdown-icon" fill="none"
                                            viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M14.752 11.168l-3.197-2.132A1 1 0 0010 9.87v4.263a1 1 0 001.555.832l3.197-2.132a1 1 0 000-1.664z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                        </svg>
                                        <span class="user-dropdown-text"><?php echo e(__('menu.save_video_view')); ?></span>
                                    </a>
                                    <a href="<?php echo e(route('dashboard.profile')); ?>" class="user-dropdown-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="user-dropdown-icon" fill="none"
                                            viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                        </svg>
                                        <span class="user-dropdown-text"><?php echo e(__('menu.profile')); ?></span>
                                    </a>
                                    
                                    <div class="user-dropdown-divider"></div>
                                    <form action="<?php echo e(route('logout')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="user-dropdown-item w-full text-left">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="user-dropdown-icon"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                                            </svg>
                                            <span class="user-dropdown-text"><?php echo e(__('menu.logout')); ?></span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if(auth()->guard()->guest()): ?>
                            <a href="<?php echo e(route('login')); ?>" class="btn-primary"><?php echo e(__('menu.login')); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </header>

        <!-- Mobile Menu -->
        <div class="mobile-menu" id="mobileMenu">
            <div class="mobile-menu-header">
                
                <button class="mobile-menu-close" id="mobileMenuClose">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <nav class="mobile-menu-nav">
                <a href="/" class="mobile-menu-link"><?php echo e(__('menu.home')); ?></a>
                <a href="/courses" class="mobile-menu-link"><?php echo e(__('menu.course')); ?></a>
                <a href="/about-us" class="mobile-menu-link"><?php echo e(__('menu.about_us')); ?></a>
                <a href="/blogs" class="mobile-menu-link"><?php echo e(__('menu.blog')); ?></a>
            </nav>
        </div>
        <div class="mobile-menu-backdrop" id="mobileMenuBackdrop"></div>
    <?php endif; ?>

    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <?php if(!$hideLayout): ?>
        <footer class="bg-secondary text-white">
            <div class="container mx-auto px-4 py-12">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                    <div>
                        <img alt="Logo" class="h-10 w-auto mb-4" src="<?php echo e(asset($websiteSetting->logo)); ?>">
                        <p class="text-gray-400">Learn new skills online with expert instructors and join our community
                            of learners.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold mb-4">Quick Links</h3>
                        <ul class="space-y-2">
                            <li><a href="/"
                                    class="text-gray-400 hover:text-white transition-colors"><?php echo e(__('menu.home')); ?></a>
                            </li>
                            <li><a href="/courses"
                                    class="text-gray-400 hover:text-white transition-colors"><?php echo e(__('menu.course')); ?></a>
                            </li>
                            <li><a href="/about-us"
                                    class="text-gray-400 hover:text-white transition-colors"><?php echo e(__('menu.about_us')); ?></a>
                            </li>
                            <li><a href="/blogs"
                                    class="text-gray-400 hover:text-white transition-colors"><?php echo e(__('menu.blog')); ?></a>
                            </li>
                        </ul>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold mb-4"></h3>
                        <ul class="space-y-2">
                            <li><a href="/privacy-policy"
                                    class="text-gray-400 hover:text-white transition-colors">Privacy Policy</a></li>
                            <li><a href="/terms-and-conditions"
                                    class="text-gray-400 hover:text-white transition-colors">Terms & Conditions</a>
                            </li>
                            <li><a href="/refund-policy"
                                    class="text-gray-400 hover:text-white transition-colors">Refund Policy</a></li>
                        </ul>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold mb-4">Contact Info</h3>
                        <ul class="space-y-2">
                            <li class="flex items-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400" fill="none"
                                    viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                </svg>
                                <span class="text-gray-400"><?php echo e($websiteSetting->address); ?></span>
                            </li>
                            <li class="flex items-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400" fill="none"
                                    viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                </svg>
                                <span class="text-gray-400"><?php echo e($websiteSetting->support_email); ?></span>
                            </li>
                            <li class="flex items-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400" fill="none"
                                    viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                </svg>
                                <span class="text-gray-400"><?php echo e($websiteSetting->mobile_number); ?></span>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="border-t border-gray-800 mt-8 pt-8 flex flex-col md:flex-row justify-between items-center">
                    <p class="text-gray-400 text-sm">© <?php echo e(date('Y')); ?> <?php echo e($websiteSetting->app_name); ?>. All
                        rights reserved.</p>
                    <div class="flex space-x-6 mt-4 md:mt-0">
                        <a href="<?php echo e($websiteSetting->facebook_link); ?>"
                            class="text-gray-400 hover:text-white transition-colors">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="currentColor"
                                viewBox="0 0 24 24">
                                <path
                                    d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z" />
                            </svg>
                        </a>
                        <a href="<?php echo e($websiteSetting->twitter_link); ?>"
                            class="text-gray-400 hover:text-white transition-colors">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="currentColor"
                                viewBox="0 0 24 24">
                                <path
                                    d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z" />
                            </svg>
                        </a>
                        <a href="<?php echo e($websiteSetting->instagram_link); ?>"
                            class="text-gray-400 hover:text-white transition-colors">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="currentColor"
                                viewBox="0 0 24 24">
                                <path
                                    d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zM5.838 12a6.162 6.162 0 1112.324 0 6.162 6.162 0 01-12.324 0zM12 16a4 4 0 110-8 4 4 0 010 8zm4.965-10.405a1.44 1.44 0 112.881.001 1.44 1.44 0 01-2.881-.001z" />
                            </svg>
                        </a>
                        <a href="<?php echo e($websiteSetting->youtube_link); ?>"
                            class="text-gray-400 hover:text-white transition-colors">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="currentColor"
                                viewBox="0 0 24 24">
                                <path
                                    d="M23.498 6.186a2.974 2.974 0 0 0-2.093-2.103C19.505 3.5 12 3.5 12 3.5s-7.505 0-9.405.583A2.974 2.974 0 0 0 .502 6.186C0 8.082 0 12 0 12s0 3.918.502 5.814a2.974 2.974 0 0 0 2.093 2.103C4.495 20.5 12 20.5 12 20.5s7.505 0 9.405-.583a2.974 2.974 0 0 0 2.093-2.103C24 15.918 24 12 24 12s0-3.918-.502-5.814zM9.75 15.568V8.432L15.818 12 9.75 15.568z" />
                            </svg>
                        </a>

                    </div>
                </div>
            </div>
        </footer>
    <?php endif; ?>

    <!-- WhatsApp Floating Button -->
    <a href="https://api.whatsapp.com/send/?phone=<?php echo e($websiteSetting->whatsapp_number); ?>"
        class="fixed bottom-5 right-5 z-50 group" target="_blank" rel="noopener noreferrer">
        <div class="relative">
            <!-- Glowing background -->
            <span class="absolute inset-0 rounded-full bg-green-500 opacity-50 blur-xl animate-pulse"></span>
            <!-- WhatsApp Icon -->
            <img src="<?php echo e(asset('assets/icons/whatsapp.webp')); ?>" alt="WhatsApp"
                class="w-14 h-14 relative z-10 transition-all duration-300 transform group-hover:scale-110 group-hover:rotate-12 shadow-lg" />
        </div>
    </a>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/js/all.min.js"
        integrity="sha512-6BTOlkauINO65nLhXhthZMtepgJSghyimIalb+crKRPhvhmsCdnIuGcVbR5/aQY2A+260iC1OPy1oCdB6pSSwQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <?php if(session('swl')): ?>
        <script src="<?php echo e(asset('assets/js/sweetalert2.min.js')); ?>"></script>
        <script>
            Swal.fire({
                icon: '<?php echo e(session('swl.type')); ?>',
                title: '<?php echo e(session('swl.title') ?? ''); ?>',
                text: '<?php echo e(session('swl.message')); ?>',
                showConfirmButton: true,
            });
        </script>
    <?php endif; ?>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Language Switcher
            const langButton = document.getElementById('langButton');
            const langDropdown = document.getElementById('langDropdown');
            const mobileLangButton = document.getElementById('mobileLangButton');
            const mobileLangDropdown = document.getElementById('mobileLangDropdown');

            if (langButton) {
                langButton.addEventListener('click', function(e) {
                    e.stopPropagation();
                    langDropdown.classList.toggle('hidden');
                });
            }

            if (mobileLangButton) {
                mobileLangButton.addEventListener('click', function(e) {
                    e.stopPropagation();
                    mobileLangDropdown.classList.toggle('hidden');
                });
            }

            // Notification Dropdown
            const notificationButton = document.getElementById('notificationButton');
            const notificationDropdown = document.getElementById('notificationDropdown');

            if (notificationButton) {
                notificationButton.addEventListener('click', function(e) {
                    e.stopPropagation();
                    notificationDropdown.classList.toggle('hidden');
                });
            }

            // User Dropdown
            const userButton = document.getElementById('userButton');
            const userDropdown = document.getElementById('userDropdown');

            if (userButton) {
                userButton.addEventListener('click', function(e) {
                    e.stopPropagation();
                    userDropdown.classList.toggle('hidden');
                });
            }

            // Mobile Menu
            const mobileMenuButton = document.getElementById('mobileMenuButton');
            const mobileMenu = document.getElementById('mobileMenu');
            const mobileMenuClose = document.getElementById('mobileMenuClose');
            const mobileMenuBackdrop = document.getElementById('mobileMenuBackdrop');

            if (mobileMenuButton) {
                mobileMenuButton.addEventListener('click', function() {
                    mobileMenu.classList.add('active');
                    mobileMenuBackdrop.classList.add('active');
                    document.body.style.overflow = 'hidden';
                });
            }

            if (mobileMenuClose) {
                mobileMenuClose.addEventListener('click', function() {
                    mobileMenu.classList.remove('active');
                    mobileMenuBackdrop.classList.remove('active');
                    document.body.style.overflow = '';
                });
            }

            if (mobileMenuBackdrop) {
                mobileMenuBackdrop.addEventListener('click', function() {
                    mobileMenu.classList.remove('active');
                    mobileMenuBackdrop.classList.remove('active');
                    document.body.style.overflow = '';
                });
            }

            // Close dropdowns when clicking outside
            document.addEventListener('click', function() {
                if (langDropdown) langDropdown.classList.add('hidden');
                if (mobileLangDropdown) mobileLangDropdown.classList.add('hidden');
                if (notificationDropdown) notificationDropdown.classList.add('hidden');
                if (userDropdown) userDropdown.classList.add('hidden');
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            IVISToast.config({
                them: 'colored',
                duration: 8000,
                position: 'top-right'
            })

            <?php if(session('ivis')): ?>
                const ivisData = <?php echo json_encode(session('ivis'), 15, 512) ?>;
                if (ivisData.type === 'success') {
                    IVISToast.success(ivisData.message);
                } else if (ivisData.type === 'error') {
                    IVISToast.error(ivisData.message);
                } else if (ivisData.type === 'warning') {
                    IVISToast.warning(ivisData.message);
                } else {
                    IVISToast.info(ivisData.message);
                }
            <?php endif; ?>
        })
    </script>
    <?php echo $__env->yieldPushContent('js'); ?>
</body>

</html>
<?php /**PATH /home/nexgenweb/lms.nexgenwebhub.com/resources/views/layouts/app.blade.php ENDPATH**/ ?>