<?php $__env->startSection('content'); ?>
    <?php $__env->startPush('css'); ?>
        <style>
            .dropdown-item {
                padding: 8px 16px;
                transition: background-color 0.2s ease;
            }
        </style>
    <?php $__env->stopPush(); ?>
    <div class="page-content">

        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 row-cols-xl-5 g-3">
            <!-- Total Enrollments -->
            <div class="col">
                <div class="card radius-10 status-card total">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Total Enrollments</p>
                                <h4 class="my-1" id="totalEnrollments"></h4>
                            </div>
                            <div class="widgets-icons rounded-circle text-white ms-auto bg-primary p-2">
                                <i class="bi bi-journal-text fs-4"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Active Enrollments -->
            <div class="col">
                <div class="card radius-10 status-card" data-status="active">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Active</p>
                                <h4 class="my-1" id="activeEnrollments"></h4>
                            </div>
                            <div class="widgets-icons rounded-circle text-white ms-auto bg-success p-2">
                                <i class="bi bi-check-circle-fill fs-4"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Optional: Inactive Enrollments -->
            <div class="col">
                <div class="card radius-10 status-card" data-status="inactive">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Inactive</p>
                                <h4 class="my-1" id="inactiveEnrollments"></h4>
                            </div>
                            <div class="widgets-icons rounded-circle text-white ms-auto bg-secondary p-2">
                                <i class="bi bi-slash-circle-fill fs-4"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Completed Enrollments -->
            <div class="col">
                <div class="card radius-10 status-card" data-status="completed">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Completed</p>
                                <h4 class="my-1" id="completedEnrollments"></h4>
                            </div>
                            <div class="widgets-icons rounded-circle text-white ms-auto bg-primary p-2">
                                <i class="bi bi-award-fill fs-4"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Cancelled Enrollments -->
            <div class="col">
                <div class="card radius-10 status-card" data-status="cancelled">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Cancelled</p>
                                <h4 class="my-1" id="cancelledEnrollments"></h4>
                            </div>
                            <div class="widgets-icons rounded-circle text-white ms-auto bg-danger p-2">
                                <i class="bi bi-x-circle-fill fs-4"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>


        <div class="row">
            <div class="col-md-12">

                <div class="card">
                    <div class="card-header bg-white border-bottom">

                        <!-- Row 1: Filters -->
                        <div class="row mb-2 g-2 align-items-center">
                            <div class="col-md-3">
                                <select name="course_id" class="form-select  select2" id="courseSelect">
                                    <option value="">All Courses</option>
                                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($course->id); ?>"><?php echo e($course->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select name="enrollment_period" class="form-select " id="enrollmentPeriod">
                                    <option value="">All Periods</option>
                                    <option value="today">Today</option>
                                    <option value="week">This Week</option>
                                    <option value="month">This Month</option>
                                    <option value="year">This Year</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select name="status_filter" class="form-select " id="statusFilter">
                                    <option value="">All Status</option>
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                    <option value="completed">Completed</option>
                                    <option value="cancelled">Cancelled</option>
                                </select>
                            </div>
                            <div class="col-md-3 d-flex">
                                <button type="button" class="btn btn-outline-secondary btn-sm ms-auto" id="resetFilters">
                                    <i class="bi bi-arrow-counterclockwise me-1"></i> Reset Filters
                                </button>
                            </div>
                        </div>

                        <script>
                            // Reset button functionality
                            $('#resetFilters').on('click', function() {
                                $('#courseSelect').val('').trigger('change'); // Reset Select2
                                $('#enrollmentPeriod').val('');
                                $('#statusFilter').val('');

                                // Optional: reload Yajra DataTable
                                $('.yajraDataDelete').DataTable().ajax.reload();
                            });
                        </script>


                        <!-- Row 2: Bulk Actions -->
                        <div class="row g-2">
                            <div class="col-md-12 d-flex gap-2 flex-wrap justify-content-end">
                                <div class="dropdown">
                                    <button class="btn btn-purple dropdown-toggle d-flex align-items-center" type="button"
                                        data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="bi bi-pencil-square me-2"></i>Update Status
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item bulk-update" data-value="active" href="#"><i
                                                    class="bi bi-check-circle-fill me-2 text-success"></i> Active</a></li>
                                        <li><a class="dropdown-item bulk-update" data-value="inactive" href="#"><i
                                                    class="bi bi-slash-circle-fill me-2 text-secondary"></i> Inactive</a>
                                        </li>
                                        <li><a class="dropdown-item bulk-update" data-value="completed" href="#"><i
                                                    class="bi bi-award-fill me-2 text-primary"></i> Completed</a></li>
                                        <li><a class="dropdown-item bulk-update" data-value="cancelled" href="#"><i
                                                    class="bi bi-x-circle-fill me-2 text-danger"></i> Cancelled</a></li>
                                    </ul>
                                </div>

                                <button type="button" id="bulkDeleteButton"
                                    class="btn btn-danger d-flex align-items-center">
                                    <i class="bi bi-trash me-2"></i>Delete
                                </button>
                            </div>
                        </div>
                    </div>





                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped my-table2 dataTable no-footer yajraDataDelete"
                                id="enrollments">
                                <thead class="thead-dark">
                                    <tr>
                                        <th style="max-width: 150px">
                                            <input type="checkbox" id="selectAll"
                                                class="form-check-input order-checkbox">
                                            Date
                                        </th>
                                        <th style="max-width: 200px">User</th>
                                        <th style="max-width: 250px">Course </th>
                                        <th style="max-width: 100px">Amount</th>
                                        <th>Note</th>
                                        <th>Status</th>
                                        <th class="text-center">Action</th>
                                    </tr>

                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <?php $__env->startPush('js'); ?>
        <script>
            $('#selectAll').on('change', function() {
                $('.rowCheckbox').prop('checked', this.checked)
            })

            $(document).on('change', '.rowCheckbox', function() {
                if ($('.rowCheckbox:checked').length === $('.rowCheckbox').length) {
                    $('#selectAll').prop('checked', true);
                } else {
                    $('#selectAll').prop('checked', false);
                }
            });
        </script>

        <script>
            $(function() {
                let enrolment = $('#enrollments').DataTable({
                    language: {
                        info: "Total Enrollments:<b> _TOTAL_ </b>| Showing _START_ to _END_",
                        search: "Search by Invoice ID or User Info:"
                    },
                    processing: true,
                    serverSide: true,
                    searchable: true,
                    ajax: {
                        url: "<?php echo e(route('admin.enrollments.index')); ?>",
                        data: function(d) {
                            d.course_id = $('#courseSelect').val();
                            d.enrollmentPeriod = $('#enrollmentPeriod').val();
                            d.status = $('#statusFilter').val();
                        },
                    },
                    columns: [{
                            data: 'date',
                            name: 'date',
                            orderable: false,
                        },
                        {
                            data: 'student',
                            name: 'student',
                        },
                        {
                            data: 'course',
                            name: 'course'
                        },
                        {
                            data: 'amount',
                            name: 'amount'
                        },
                      
                        {
                            data: 'note',
                            name: 'note'
                        },
                        {
                            data: 'status',
                            name: 'status'
                        },
                        
                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        }
                    ],
                    drawCallback: function(settings) {
                        var json = settings.json;
                        if (json) {
                            $('#activeEnrollments').text(json.activeEnrollments || 0);
                            $('#completedEnrollments').text(json.completedEnrollments || 0);
                            $('#cancelledEnrollments').text(json.cancelledEnrollments || 0);
                            $('#inactiveEnrollments').text(json.inactiveEnrollments || 0);
                            $('#totalEnrollments').text(json.totalEnrollments || 0);
                        }
                    }
                });

                $('#courseSelect,#enrollmentPeriod,#statusFilter').on('change', function() {
                    enrolment.ajax.reload();
                });


                $('#bulkDeleteButton').on('click', function(e) {
                    e.preventDefault();

                    // Collect selected row IDs
                    let selectedIds = [];
                    $('.rowCheckbox:checked').each(function() {
                        selectedIds.push($(this).val());
                    });

                    if (selectedIds.length === 0) {
                        // Show warning if nothing selected
                        Swal.fire({
                            icon: 'warning',
                            title: 'No Selection',
                            text: 'Please select at least one record to delete.'
                        });
                        return; // Stop execution
                    }

                    let destroyUrl = "<?php echo e(route('admin.enrollments.bulk-delete')); ?>"; // Your bulk delete route

                    // Confirm deletion
                    Swal.fire({
                        title: "Are you sure to delete selected data?",
                        text: "The data will be permanently deleted",
                        icon: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#d33",
                        cancelButtonColor: "#3085d6",
                        confirmButtonText: "Yes, delete it!"
                    }).then((result) => {
                        if (result.isConfirmed) {
                            Swal.fire({
                                title: 'Deleting...',
                                text: 'Please wait!',
                                allowOutsideClick: false,
                                didOpen: () => Swal.showLoading()
                            });

                            $.ajax({
                                url: destroyUrl,
                                method: 'DELETE', // safer than DELETE for bulk with IDs
                                data: {
                                    _token: $('meta[name="csrf-token"]').attr('content'),
                                    enrollment_ids: selectedIds
                                },
                                success: function(res) {
                                    Swal.close();
                                    if (res.status === true) {
                                        $('.yajraDataDelete').DataTable().ajax.reload(null,
                                            false);
                                        Swal.fire({
                                            icon: 'success',
                                            title: 'Deleted!',
                                            text: res.message ||
                                                'Selected data deleted successfully.'
                                        });
                                    } else {
                                        Swal.fire({
                                            icon: 'error',
                                            title: 'Error!',
                                            text: res.message ||
                                                'Something went wrong.'
                                        });
                                    }
                                },
                                error: function(xhr) {
                                    Swal.close();
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Error!',
                                        text: xhr.responseJSON?.message ||
                                            'Delete failed. Please try again.'
                                    });
                                }
                            });
                        }
                    });
                });

            });


            $('.yajraDataDelete').on('click', '.edit_note_btn', function() {

                let note = $(this).data('note') || '';
                let enrollmentId = $(this).data('id');
                console.log('Enrollment ID:', enrollmentId); // Log the enrollment ID to verify it's being captured

                Swal.fire({
                    title: 'Edit Note',
                    input: 'textarea',
                    inputLabel: 'Update Note',
                    inputValue: note,
                    showCancelButton: true,
                    confirmButtonText: 'Update',
                    cancelButtonText: 'Cancel',
                    inputAttributes: {
                        'aria-label': 'Type your note here'
                    },
                    preConfirm: (updatedNote) => {
                        if (!updatedNote) {
                            Swal.showValidationMessage('Note cannot be empty');
                        }
                        return updatedNote;
                    }
                }).then((result) => {
                    if (result.isConfirmed) {
                        let updatedNote = result.value;

                        $.ajax({
                            url: '<?php echo e(route('admin.enrollments.update-note')); ?>',
                            method: 'PUT',
                            data: {
                                _token: $('meta[name="csrf-token"]').attr('content'),
                                note: updatedNote,
                                enrollment_id: enrollmentId
                            },
                            success: function(res) {
                                if (res.status === true) {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Updated!',
                                        text: res.message || 'Note updated successfully.'
                                    });
                                    $('.yajraDataDelete').DataTable().ajax.reload(null, false);
                                } else {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Error!',
                                        text: res.message || 'Something went wrong.'
                                    });
                                }
                            },
                            error: function(xhr) {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error!',
                                    text: xhr.responseJSON?.message ||
                                        'Update failed. Please try again.'
                                });
                            }
                        });
                    }
                });
            });




            // Bulk status update
            $('.bulk-update').on('click', function(e) {
                e.preventDefault();

                // Status from dropdown
                let status = $(this).data('value');

                // Collect selected enrollment IDs
                let selectedIds = [];
                $('.rowCheckbox:checked').each(function() {
                    selectedIds.push($(this).val());
                });

                if (selectedIds.length === 0) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'No Selection',
                        text: 'Please select at least one enrollment to update.'
                    });
                    return;
                }

                // Confirmation
                Swal.fire({
                    title: 'Are you sure?',
                    text: `You want to update ${selectedIds.length} enrollments to "${status}"?`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, Update',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        Swal.fire({
                            title: 'Updating...',
                            text: 'Please wait!',
                            allowOutsideClick: false,
                            didOpen: () => Swal.showLoading()
                        });

                        $.ajax({
                            url: '<?php echo e(route('admin.enrollments.bulk-update-status')); ?>',
                            method: 'PUT',
                            data: {
                                _token: $('meta[name="csrf-token"]').attr('content'),
                                status: status,
                                enrollment_ids: selectedIds
                            },
                            success: function(res) {
                                Swal.close();
                                if (res.status === true) {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Updated!',
                                        text: res.message || 'Status updated successfully.'
                                    });
                                    $('.yajraDataDelete').DataTable().ajax.reload(null, false);
                                } else {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Error!',
                                        text: res.message || 'Something went wrong.'
                                    });
                                }
                            },
                            error: function(xhr) {
                                Swal.close();
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error!',
                                    text: xhr.responseJSON?.message ||
                                        'Update failed. Please try again.'
                                });
                            }
                        });
                    }
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nexgenweb/lms.nexgenwebhub.com/resources/views/backend/page/enrollment/index.blade.php ENDPATH**/ ?>