<?php $__env->startSection('title', $course->title ?? ($seoSetting->site_title ?? $websiteSetting->app_name)); ?>
<?php $__env->startSection('description', $course->short_description ?? ($seoSetting->meta_description ?? 'Default description here')); ?>
<?php $__env->startSection('keywords', $course->category->name ?? ($seoSetting->meta_keywords ?? 'Online course, learning, education')); ?>
<?php $__env->startSection('image', asset($course->thumbnail_url ?? $websiteSetting->logo)); ?>
<?php $__env->startSection('url', url()->current()); ?>



<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/sweetalert2.min.css')); ?>">
    <style>
        .rotate-180 {
            transform: rotate(0deg);
        }


        .accordion-content {
            transition: max-height 0.3s ease-in-out;
            overflow: hidden;
        }

        .prose li,
        .prose li span {
            color: #E2E8D0 !important;
            /* Forces light text for list items */
        }

        .prose li::marker {
            color: #c8a050 !important;
            /* Forces bullet color */
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="">
        <div class="rounded-md px-2 md:px-4 py-6 md:py-14">

            <div class="container mx-auto px-4 py-12">

                <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                    <div class="lg:col-span-2 order-2 md:order-1">
                        <div class="rounded-xl shadow-sm p-1 sticky top-20 z-10">
                            <div class="bg-[#15253f] rounded-xl shadow-sm p-1 mb-8 sticky top-20 z-10">
                                <div class="flex flex-nowrap overflow-x-auto" id="section-nav">
                                    <?php $__currentLoopData = ['instructors' => 'Instructors', 'overview' => 'Overview', 'curriculum' => 'Curriculum', 'enrollment' => 'Enrollment']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="#<?php echo e($id); ?>"
                                            class="section-link flex-shrink-0 px-4 py-2 rounded-lg text-sm font-medium text-[#E2E8D0] hover:bg-[#1c2a4a] transition-colors">
                                            <?php echo e($label); ?>

                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                        <!-- Instructors Section -->
                        <section id="instructors" class="bg-[#15253f] rounded-xl shadow-sm p-6 md:p-8 mb-8">
                            <h2 class="text-2xl font-bold text-[#c8a050] mb-6">Meet Your Instructors</h2>
                            <div class="grid grid-cols-2 md:grid-cols-3 gap-6">
                                <?php $__currentLoopData = $course->instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e(route('instructor.details', $instructor->id)); ?>">
                                        <div
                                            class="flex flex-col items-center text-center p-4 border border-[#1c2a4a] rounded-lg hover:shadow-md transition">
                                            <img src="<?php echo e(asset($instructor->user->image ?? 'assets/images/default-user.png')); ?>"
                                                alt="<?php echo e($instructor->user->name); ?>"
                                                class="w-20 h-20 rounded-full object-cover mb-3">
                                            <h3 class="text-base font-semibold !text-[#E2E8D0]">
                                                <?php echo e($instructor->user->name); ?>

                                            </h3>
                                        </div>
                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </section>

                        <!-- Overview Section -->
                        <section id="overview" class="bg-[#15253f] rounded-xl shadow-sm p-6 md:p-8 mb-8">
                            <h2 class="text-2xl font-bold !text-[#c8a050] mb-6">Course Overview</h2>
                            <div
                                class="prose max-w-none
                [&_p]:!text-[#E2E8D0] [&_p]:!text-opacity-100
                [&_h1]:!text-[#E2E8D0] [&_h2]:!text-[#E2E8D0] [&_h3]:!text-[#E2E8D0] [&_h4]:!text-[#E2E8D0]
                [&_li]:!text-[#E2E8D0] [&_li]:!text-opacity-100
                [&_li::marker]:!text-[#c8a050]
                [&_a]:!text-[#c8a050] [&_a:hover]:!text-[#fbbf24]
                [&_strong]:!text-[#E2E8D0] [&_em]:!text-[#E2E8D0]">
                                <?php echo $course->description; ?>

                            </div>
                        </section>

                        <!-- Curriculum Section -->
                        <section id="curriculum"
                            class="bg-[#15253f] rounded-2xl shadow-md p-8 mb-10 border border-[#1c2a4a]">
                            <div class="flex justify-between items-center mb-8">
                                <h2 class="text-3xl font-bold text-[#c8a050]">Course Curriculum</h2>
                                <span class="text-sm !text-[#E2E8D0] text-opacity-70"><?php echo e($course->module->count()); ?>

                                    Modules</span>
                            </div>

                            <div class="relative space-y-8">
                                <div
                                    class="absolute top-0 left-6 h-full w-[3px] bg-gradient-to-b from-[#c8a050] to-[#c8a050]/20 rounded-full">
                                </div>

                                <?php $__empty_1 = true; $__currentLoopData = $course->module; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="relative pl-14 pb-4">
                                        <!-- Module Marker -->
                                        <div
                                            class="absolute left-0 top-0 h-10 w-10 rounded-full bg-[#c8a050] text-[#0F172A] flex items-center justify-center font-bold text-lg shadow-md">
                                            <?php echo e($loop->iteration); ?>

                                        </div>

                                        <!-- Module Card -->
                                        <div
                                            class="bg-[#1c2a4a] rounded-xl border border-[#15253f] overflow-hidden hover:shadow-lg transition-shadow">
                                            <!-- Header -->
                                            <button type="button"
                                                class="w-full flex justify-between items-center p-5 text-left font-semibold text-[#E2E8D0] hover:bg-[#15253f] course_syllabus_header">
                                                <div>
                                                    <h3 class="text-lg font-bold"><?php echo e($module->title); ?></h3>
                                                    <span
                                                        class="text-sm !text-[#E2E8D0] text-opacity-60"><?php echo e($module->moduleContent->count()); ?>

                                                        Lessons</span>
                                                </div>
                                                <svg class="size-5 close_icons_syllabus !text-[#E2E8D0]" fill="none"
                                                    stroke="currentColor" viewBox="0 0 24 24">
                                                    <path d="M8 12h8M12 8v8" stroke-width="2" stroke-linecap="round" />
                                                </svg>
                                                <svg class="size-5 open_icons_syllabus !text-[#E2E8D0] hidden"
                                                    fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path d="M8 12h8" stroke-width="2" stroke-linecap="round" />
                                                </svg>
                                            </button>

                                            <div
                                                class="course_syllabus_content hidden border-t border-[#15253f] divide-y divide-[#15253f]">
                                                <?php $__empty_2 = true; $__currentLoopData = $module->moduleContent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                    <?php
                                                        $isFree = $content->is_free;
                                                        $type = $content->content_type;
                                                    ?>
                                                    <div class="flex items-center group px-5 py-4 gap-4 hover:bg-[#15253f] transition cursor-pointer"
                                                        <?php if($type == 'video' && $isFree): ?> onclick="openVideoModal('https://www.youtube.com/embed/<?php echo e($content->content_url); ?>')" <?php endif; ?>>
                                                        <div>
                                                            <?php if($type === 'video'): ?>
                                                                <svg class="size-6 text-[#c8a050]" fill="none"
                                                                    stroke="currentColor" viewBox="0 0 24 24">
                                                                    <circle cx="12" cy="12" r="10"
                                                                        stroke-width="2" />
                                                                    <polygon points="10 8 16 12 10 16" stroke-width="2" />
                                                                </svg>
                                                            <?php elseif($type === 'quiz'): ?>
                                                                <svg class="size-6 text-indigo-600" fill="currentColor"
                                                                    viewBox="0 0 24 24">
                                                                    <path
                                                                        d="M12 2C6.5 2 2 6 2 12s4.5 10 10 10 10-4 10-10S17.5 2 12 2Z" />
                                                                    <circle cx="12" cy="17" r="1.2"
                                                                        fill="#fff" />
                                                                    <path stroke="#fff" stroke-width="1.8" d="M12 7v5" />
                                                                </svg>
                                                            <?php else: ?>
                                                                <svg class="size-6 text-orange-600" fill="none"
                                                                    stroke="currentColor" viewBox="0 0 24 24">
                                                                    <path d="M6 2h9l5 5v13H6z" stroke-width="2" />
                                                                    <path d="M14 2v5h5" stroke-width="2" />
                                                                </svg>
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="flex-1">
                                                            <p
                                                                class="font-medium !text-[#E2E8D0] group-hover:text-[#c8a050] transition">
                                                                <?php echo e($content->title); ?>

                                                            </p>
                                                            <span
                                                                class="text-sm !text-[#E2E8D0] text-opacity-60"><?php echo e(ucfirst($type)); ?></span>
                                                        </div>
                                                        <div>
                                                            <?php if(!$isFree): ?>
                                                                <svg class="size-5 text-gray-400" fill="none"
                                                                    stroke="currentColor" viewBox="0 0 24 24">
                                                                    <circle cx="12" cy="15" r="1" />
                                                                    <path d="M7 10V7a5 5 0 0 1 10 0v3"
                                                                        stroke-linecap="round" />
                                                                    <rect x="3" y="10" width="18" height="12"
                                                                        rx="2" />
                                                                </svg>
                                                            <?php else: ?>
                                                                <span
                                                                    class="text-xs px-2 py-1 bg-green-100 text-green-600 rounded-md">Free</span>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                                    <p class="px-5 py-3 text-sm !text-[#E2E8D0] text-opacity-60">
                                                        <?php echo e(__('text.content_not_found')); ?></p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="text-center !text-[#E2E8D0] text-opacity-60 py-4">
                                        <?php echo e(__('messages.syllabus_coming')); ?></div>
                                <?php endif; ?>
                            </div>
                        </section>

                        <!-- Enrollment Section -->
                        <section id="enrollment" class="bg-[#15253f] rounded-xl shadow-sm p-6 md:p-8">
                            <h2 class="text-2xl font-bold text-[#c8a050] mb-6">How to Enroll</h2>
                            <div class="space-y-6">
                                <?php $__currentLoopData = [
            1 => ['title' => 'Create an Account', 'text' => 'Sign up for a free account...'],
            2 => ['title' => 'Enroll in the Course', 'text' => 'Navigate to the course page...'],
            3 => ['title' => 'Join the Community', 'text' => 'After enrollment...'],
            4 => ['title' => 'Start Learning', 'text' => 'Access your course dashboard...'],
        ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $step => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="flex items-start space-x-4">
                                        <div
                                            class="flex-shrink-0 w-8 h-8 bg-teal-600 text-[#0F172A] rounded-full flex items-center justify-center font-semibold">
                                            <?php echo e($step); ?>

                                        </div>
                                        <div>
                                            <h3 class="text-lg font-semibold !text-[#E2E8D0] mb-2"><?php echo e($item['title']); ?>

                                            </h3>
                                            <p class="!text-[#E2E8D0] text-opacity-80"><?php echo e($item['text']); ?></p>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </section>

                    </div>

                    <div class="lg:col-span-1 order-1 md:order-2">
                        <section class="w-full  md:bg-white">
                            <div class="md:sticky md:top-[112px]">
                                <div class="md:border border-slate-300 rounded-sm">

                                    <div class=" p-1.5 rounded-sm">
                                        <!-- Media Display Section -->
                                        <div class="relative bg-black aspect-video overflow-hidden ">
                                            <!-- Video Player (hidden by default) -->
                                            <div id="player">
                                                <iframe id="video-frame"
                                                    class="hidden absolute top-0 left-0 w-full h-full" frameborder="0"
                                                    allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                                    allowfullscreen>
                                                </iframe>
                                            </div>

                                            <!-- Video Thumbnail (visible by default) -->
                                            <div id="video-thumbnail"
                                                class="absolute inset-0 flex items-center justify-center cursor-pointer">
                                                <img src="https://via.placeholder.com/480x360?text=No+Thumbnail"
                                                    class="absolute inset-0 w-full h-full object-cover"
                                                    alt="Video Thumbnail">
                                                <div
                                                    class="bg-black/40 w-full h-full flex justify-center items-center z-10">
                                                    <div
                                                        class="relative z-10 w-14 h-14 bg-gray-50/90 text-primary rounded-full flex items-center justify-center shadow-lg animation-pulse">
                                                        <svg aria-hidden="true" focusable="false" data-prefix="fas"
                                                            data-icon="play" class="h-5.5 w-5.5 text-primary pl-0.5"
                                                            role="img" xmlns="http://www.w3.org/2000/svg"
                                                            viewBox="0 0 384 512">
                                                            <path fill="currentColor"
                                                                d="M361 215C375.3 223.8 384 239.3 384 256C384 272.7 375.3 288.2 361 296.1L73.03 472.1C58.21 482 39.66 482.4 24.52 473.9C9.377 465.4 0 449.4 0 432V80C0 62.64 9.377 46.63 24.52 38.13C39.66 29.64 58.21 29.99 73.03 39.04L361 215z">
                                                            </path>
                                                        </svg>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Image Display (hidden by default) -->
                                            <img id="main-display" class="hidden w-full h-full object-cover"
                                                alt="Display Image">
                                        </div>

                                        <!-- Thumbnail Gallery -->
                                        <div class="flex justify-between items-center">
                                            <div class="flex items-center gap-1 mt-2  pb-2">
                                                <!-- Default Video Thumbnail (Active) -->
                                                <?php if($course->video_intro_url): ?>
                                                    <div onclick="showMedia('video', '<?php echo e($course->video_intro_url); ?>', 'https://img.youtube.com/vi/<?php echo e($course->video_intro_url); ?>/maxresdefault.jpg')"
                                                        class="cursor-pointer border border-blue-500 p-0.5 relative">
                                                        <img src="https://img.youtube.com/vi/<?php echo e($course->video_intro_url); ?>/mqdefault.jpg"
                                                            class="w-14 h-10 object-cover" alt="Video 1">
                                                        <div class="absolute inset-0 flex items-center justify-center">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="white" class="w-5 h-5 shadow-lg">
                                                                <path
                                                                    d="M5.536 21.886a1.004 1.004 0 0 0 1.033-.064l13-9a1 1 0 0 0 0-1.644l-13-9A1 1 0 0 0 5 3v18a1 1 0 0 0 .536.886z">
                                                                </path>
                                                            </svg>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>

                                                <!-- Image Thumbnail -->
                                                <div onclick="showMedia('image', '<?php echo e(asset($course->thumbnail_url)); ?>')"
                                                    class="cursor-pointer border border-gray-300 p-0.5">
                                                    <img src="<?php echo e(asset($course->thumbnail_url)); ?>"
                                                        class="w-14 h-10 object-cover" alt="Image 1">
                                                </div>
                                            </div>
                                            <?php if(!$course->is_free): ?>
                                                <button
                                                    onclick="addCopune('coupon_apply_wrapper_lg','enroll_button_lg_not')"
                                                    class="items-center justify-center gap-2 whitespace-nowrap cursor-pointer font-medium transition-colors   border border-slate-300 bg-background shadow-xs hover:bg-gray-100 h-8 rounded-md px-3 text-xs hidden md:inline-flex">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                                        viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                        class="lucide lucide-clipboard-pen-line">
                                                        <rect width="8" height="4" x="8" y="2" rx="1">
                                                        </rect>
                                                        <path
                                                            d="M8 4H6a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-.5">
                                                        </path>
                                                        <path d="M16 4h2a2 2 0 0 1 1.73 1"></path>
                                                        <path d="M8 18h1"></path>
                                                        <path
                                                            d="M21.378 12.626a1 1 0 0 0-3.004-3.004l-4.01 4.012a2 2 0 0 0-.506.854l-.837 2.87a.5.5 0 0 0 .62.62l2.87-.837a2 2 0 0 0 .854-.506z">
                                                        </path>
                                                    </svg>


                                                    Coupon
                                                </button>
                                            <?php endif; ?>
                                        </div>


                                        <?php if($enrolled): ?>
                                            <a href="<?php echo e(route('dashboard.my-course.view', $course->id)); ?>"
                                                class="block w-full  mt-3.5 btn-primary text-center">View Course</a>
                                        <?php else: ?>
                                            <form action="<?php echo e(route('checkout')); ?>" method="POST"
                                                class="hidden md:block px-2">
                                                <?php echo csrf_field(); ?>
                                                <div class="relative flex items-center gap-2 hidden py-2"
                                                    id="coupon_apply_wrapper_lg">
                                                    <!-- Close Icon -->
                                                    <div class="text-red-600 hover:text-red-700 duration-150"
                                                        onclick="removeCouponWrapper('coupon_apply_wrapper_lg','enroll_button_lg')">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24"
                                                            height="24" viewBox="0 0 24 24" fill="none"
                                                            stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                                            stroke-linejoin="round"
                                                            class="text-destructive cursor-pointer">
                                                            <circle cx="12" cy="12" r="10"></circle>
                                                            <path d="m15 9-6 6"></path>
                                                            <path d="m9 9 6 6"></path>
                                                        </svg>
                                                    </div>

                                                    <!-- Input -->
                                                    <input class="flex-1 px-3 py-1 h-9.5 " id="copuneCode_lg"
                                                        placeholder="Enter code" type="text">
                                                    <input type="hidden" name="coupon_id_lg" id="coupon_id_lg">
                                                    <input type="hidden" name="course_id" value="<?php echo e($course->id); ?>"
                                                        id="course_id">

                                                    <!-- Button -->
                                                    <button type="button"
                                                        class="h-9 px-4 rounded-md bg-primary hover:bg-primary-dark cursor-pointer text-white font-medium shadow-sm "
                                                        onclick="applyCupon('<?php echo e($course->id); ?>','copuneCode_lg','coupon_id_lg','main_price_lg')">
                                                        Apply
                                                    </button>

                                                </div>

                                                <div class="w-full md:h-auto">
                                                    <div class="flex flex-col w-full">

                                                        <div>
                                                            <!-- Enrollment Box -->
                                                            <div
                                                                class="bg-[#15253f] rounded-xl p-4 shadow-md border border-[#1c2a4a]">
                                                                <?php if($course->is_free): ?>
                                                                    <span
                                                                        class="inline-block px-4 py-1 text-lg font-semibold text-white bg-red-500 rounded-md shadow-sm my-0.5"><?php echo e(__('text.free')); ?></span>
                                                                <?php else: ?>
                                                                    <div class="py-2">
                                                                        <div class="inline-block text-3xl font-semibold text-[#E2E8D0]"
                                                                            id="main_price_lg">
                                                                            ৳<?php echo e((int) $course->discounted_price); ?></div>
                                                                        <span class="inline-flex items-center">
                                                                            <del
                                                                                class="ml-2 text-base font-normal text-[#E2E8D0] text-opacity-60">৳<?php echo e((float) $course->original_price); ?></del>
                                                                            <div class="w-fit h-fit ml-4 pr-6 rounded-[2px] font-bold text-[15px] bg-[#c8a050] text-[#0F172A] shadow-md px-2 py-1 relative inline-block"
                                                                                style="clip-path: polygon(100% 0%, 85% 50%, 100% 100%, 0px 100%, 0px 0px);">
                                                                                <?php echo e($course->discount_percentage); ?>% OFF
                                                                            </div>
                                                                        </span>
                                                                    </div>
                                                                <?php endif; ?>
                                                                <div class="grid grid-cols-2 gap-3 mt-4">
                                                                    <div
                                                                        class="bg-[#1c2a4a] rounded-lg shadow-sm border border-[#15253f] p-4 text-center">
                                                                        <p
                                                                            class="text-[13px] font-medium text-[#E2E8D0] text-opacity-70">
                                                                            <?php echo e(__('text.enrolled')); ?></p>
                                                                        <p
                                                                            class="text-[22px] font-extrabold text-teal-600 tracking-tight">
                                                                            <?php echo e($course->total_enroll); ?></p>
                                                                    </div>
                                                                    <div
                                                                        class="bg-[#1c2a4a] rounded-lg shadow-sm border border-[#15253f] p-4 text-center">
                                                                        <p
                                                                            class="text-[13px] font-medium text-[#E2E8D0] text-opacity-70">
                                                                            <?php echo e(__('text.class')); ?></p>
                                                                        <p
                                                                            class="text-[22px] font-extrabold text-teal-600 tracking-tight">
                                                                            <?php echo e($course->total_class); ?></p>
                                                                    </div>
                                                                </div>
                                                                <?php if($course->status == 'draft'): ?>
                                                                    <h3
                                                                        class="bg-yellow-50 border border-yellow-200 rounded-md text-yellow-500 font-medium py-2.5 text-center mt-3.5 flex items-center justify-center">
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            class="w-4 h-4 mr-1" fill="none"
                                                                            viewBox="0 0 24 24" stroke="currentColor">
                                                                            <path stroke-linecap="round"
                                                                                stroke-linejoin="round" stroke-width="2"
                                                                                d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                                        </svg>
                                                                        Coming Soon
                                                                    </h3>
                                                                <?php else: ?>
                                                                    <?php if(auth()->guard()->check()): ?>
                                                                        <button type="button" onclick="openPaymentModal()"
                                                                            class="block w-full mt-3.5 btn-primary text-center"><?php echo e(__('menu.enroll_btn')); ?></button>
                                                                    <?php else: ?>
                                                                        <button type="submit"
                                                                            class="block w-full mt-3.5 btn-primary text-center"><?php echo e(__('menu.enroll_btn')); ?></button>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                        

                                                    </div>
                                                </div>
                                            </form>
                                        <?php endif; ?>
                                    </div>


                                    <?php if(!$enrolled): ?>
                                        <form action="<?php echo e(route('checkout')); ?>" method="POST"
                                            class="bg-white p-4  fixed z-20 w-full bottom-0 left-0 shadow-[0px_-8px_16px_0px_rgba(0,0,0,0.08)] border-t-2 border-dashed border-slate-200 md:hidden block">
                                            <?php echo csrf_field(); ?>
                                            <?php if($course->is_free): ?>
                                                <span
                                                    class="inline-block px-4 py-1 text-lg font-semibold text-white bg-red-500 rounded-md shadow-sm my-0.5">
                                                    <?php echo e(__('text.free')); ?>

                                                </span>
                                            <?php else: ?>
                                                <div class="flex justify-between">
                                                    <div>
                                                        <div class="inline-block text-[26px] font-semibold"
                                                            id="main_price_sm">
                                                            ৳<?php echo e((int) $course->discounted_price); ?></div>
                                                        <span class="inline-flex  items-center">
                                                            <del
                                                                class="ml-2 font-normal text-base">৳<?php echo e((float) $course->original_price); ?></del>
                                                            <div class="w-fit h-fit ml-2 pr-4 rounded-[2px] font-bold text-[15px] bg-secondary text-white shadow-md px-2 py-1 relative inline-flex items-center"
                                                                style="clip-path: polygon(100% 0%, 85% 50%, 100% 100%, 0px 100%, 0px 0px);">
                                                                <?php echo e($course->discount_percentage); ?>%
                                                                OFF</div>
                                                        </span>
                                                    </div>
                                                    <button type="button"
                                                        onclick="addCopune('coupon_apply_wrapper_sm','enroll_button_sm')"
                                                        class="inline-flex items-center justify-center gap-2 whitespace-nowrap cursor-pointer font-medium transition-colors   border border-slate-300 bg-background shadow-xs hover:bg-gray-100 h-8 rounded-md px-3 text-xs">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="18"
                                                            height="18" viewBox="0 0 24 24" fill="none"
                                                            stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                                            stroke-linejoin="round"
                                                            class="lucide lucide-clipboard-pen-line">
                                                            <rect width="8" height="4" x="8" y="2"
                                                                rx="1">
                                                            </rect>
                                                            <path
                                                                d="M8 4H6a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-.5">
                                                            </path>
                                                            <path d="M16 4h2a2 2 0 0 1 1.73 1"></path>
                                                            <path d="M8 18h1"></path>
                                                            <path
                                                                d="M21.378 12.626a1 1 0 0 0-3.004-3.004l-4.01 4.012a2 2 0 0 0-.506.854l-.837 2.87a.5.5 0 0 0 .62.62l2.87-.837a2 2 0 0 0 .854-.506z">
                                                            </path>
                                                        </svg>

                                                        Coupon</button>
                                                </div>
                                            <?php endif; ?>


                                            <?php if($course->status == 'draft'): ?>
                                                <h3
                                                    class="bg-yellow-50 border border-yellow-200 rounded-md text-yellow-500 font-medium py-2.5 mt-3.5  text-center flex items-center justify-center">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 mr-1"
                                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2"
                                                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                    </svg>
                                                    Coming Soon
                                                </h3>
                                            <?php else: ?>
                                                <?php if(auth()->guard()->check()): ?>
                                                    <button type="button" onclick="openPaymentModal()"
                                                        class="block w-full  mt-3.5 btn-primary text-center"
                                                        id="enroll_button_lg">
                                                        <?php echo e(__('menu.enroll_btn')); ?>

                                                    </button>
                                                <?php else: ?>
                                                    <button type="submit"
                                                        class="block w-full  mt-3.5 btn-primary text-center"
                                                        id="enroll_button_lg">
                                                        <?php echo e(__('menu.enroll_btn')); ?>

                                                    </button>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                            <div class="relative flex items-center gap-2 hidden mt-2"
                                                id="coupon_apply_wrapper_sm">
                                                <!-- Close Icon -->
                                                <div class="text-red-600 hover:text-red-700 duration-150"
                                                    onclick="removeCouponWrapper('coupon_apply_wrapper_sm','enroll_button_sm')">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                        viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                        class="text-destructive cursor-pointer">
                                                        <circle cx="12" cy="12" r="10"></circle>
                                                        <path d="m15 9-6 6"></path>
                                                        <path d="m9 9 6 6"></path>
                                                    </svg>
                                                </div>

                                                <!-- Input -->
                                                <input class="flex-1 px-3 py-1 h-9.5 " id='copuneCode_sm'
                                                    placeholder="Enter code" type="text">
                                                <input type="hidden" name="coupon_id_sm" id="coupon_id_sm">
                                                <input type="hidden" name="course_id" value="<?php echo e($course->id); ?>"
                                                    id="course_id">

                                                <!-- Button -->
                                                <button type="button"
                                                    class="h-9 px-4 rounded-md bg-primary hover:bg-primary-dark cursor-pointer text-white font-medium shadow-sm "
                                                    onclick="applyCupon('<?php echo e($course->id); ?>','copuneCode_sm','coupon_id_sm','main_price_sm')">
                                                    Apply
                                                </button>

                                            </div>
                                        </form>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </section>
                    </div>


                </div>
            </div>

        </div>
        <!-- Payment Modal -->
        <div id="paymentModal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black/50">
            <div class="bg-white rounded-2xl w-full max-w-2xl p-6 md:p-8 relative">
                <!-- Close Button -->
                <button onclick="closePaymentModal()" class="absolute top-4 right-4 text-gray-500 hover:text-gray-700">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none"
                        stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"></circle>
                        <path d="M15 9l-6 6"></path>
                        <path d="M9 9l6 6"></path>
                    </svg>
                </button>

                <h2 class="text-2xl font-bold text-gray-900 mb-4">Select Payment Method</h2>

                <form action="<?php echo e(route('payment')); ?>" method="POST" id="modalPaymentForm">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="course_id" value="<?php echo e($course->id); ?>">
                    <input type="hidden" name="coupon_id" id="modal_coupon_id" value="">

                    <!-- Payment Gateways -->
                    <div class="space-y-3">
                        <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label
                                class="flex items-center justify-between border rounded-lg p-3 cursor-pointer hover:shadow-sm">
                                <div class="flex items-center gap-3">
                                    <input type="radio" name="payment" value="<?php echo e($gateway->id); ?>"
                                        class="accent-green-600 h-4 w-4" <?php echo e($loop->first ? 'checked' : ''); ?>>
                                    <span class="font-medium"><?php echo e($gateway->gateway_name); ?></span>
                                </div>
                                <img src="<?php echo e(asset($gateway->image_url)); ?>" alt="<?php echo e($gateway->gateway_name); ?>"
                                    class="w-20">
                            </label>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <!-- Total & Pay Button -->
                    <div class="mt-6 flex justify-between items-center">
                        <div class="text-lg font-bold text-black">
                            Total: <span id="modal_total_price" class="!text-black">৳<?php echo e((int) $course->discounted_price); ?></span>
                        </div>
                        <button type="submit" class="btn-primary px-6 py-2 rounded-lg">
                            Make Payment
                        </button>
                    </div>
                </form>
            </div>
        </div>
        <div id="videoModal" class="hidden fixed inset-0 z-[1000] bg-black/90 flex items-center justify-center p-4">
            <div class="relative w-full max-w-4xl bg-white">

                <button onclick="closeVideoModal()"
                    class=" absolute -top-10 right-0 text-white cursor-pointer text-4xl hover:text-gray-300 transition-colors">
                    &times;
                </button>

                <iframe id="youtubeVideo" class="w-full aspect-video" src="" frameborder="0"
                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                    allowfullscreen></iframe>
            </div>
        </div>
    <?php $__env->stopSection(); ?>

    <?php $__env->startPush('js'); ?>
        <script src="<?php echo e(asset('assets/js/sweetalert2.min.js')); ?>"></script>

        <script>
            $(document).ready(function() {
                $('.course_syllabus_header').on('click', function() {
                    $(this).next('.course_syllabus_content').slideToggle();
                    $(this).find('.close_icons_syllabus').toggleClass('hidden');
                    $(this).find('.open_icons_syllabus').toggleClass('hidden');
                });
            })
        </script>


        <script>
            $(document).ready(function() {
                $('.accordion-header').on('click', function() {
                    // Close all other accordion items first
                    $(this).next('.accordion-content').addClass('pb-3');
                    $('.accordion-content').not($(this).next()).slideUp();
                    $('.accordion-arrow').not($(this).find('.accordion-arrow')).removeClass('rotate-180');

                    // Toggle current item
                    $(this).find('.accordion-arrow').toggleClass('rotate-180');
                    $(this).next('.accordion-content').slideToggle();

                });
            });
        </script>





        <script>
            // Initialize with default video thumbnail
            document.addEventListener('DOMContentLoaded', function() {
                const videoThumbnail = document.getElementById('video-thumbnail');
                const videoFrame = document.getElementById('video-frame');

                // When main thumbnail is clicked
                videoThumbnail.addEventListener('click', function() {
                    const currentVideoSrc = videoFrame.src;
                    videoFrame.src = currentVideoSrc.includes('?') ?
                        currentVideoSrc + '&autoplay=1&mute=1' :
                        currentVideoSrc + '?autoplay=1&mute=1';

                    this.classList.add('hidden');
                    videoFrame.classList.remove('hidden');
                });
            });

            function showMedia(type, src, thumb) {
                const videoFrame = document.getElementById('video-frame');
                const videoThumbnail = document.getElementById('video-thumbnail');
                const mainDisplay = document.getElementById('main-display');

                // Reset all thumbnail borders
                document.querySelectorAll('[onclick^="showMedia"]').forEach(thumb => {
                    thumb.classList.remove('border-blue-500');
                    thumb.classList.add('border-gray-300');
                });

                // Highlight clicked thumbnail
                event.currentTarget.classList.remove('border-gray-300');
                event.currentTarget.classList.add('border-blue-500');

                if (type === 'video') {
                    // Show video thumbnail
                    videoFrame.src = `https://www.youtube.com/embed/${src}?rel=0`;
                    videoThumbnail.querySelector('img').src = thumb;

                    videoThumbnail.classList.remove('hidden');
                    videoFrame.classList.add('hidden');
                    mainDisplay.classList.add('hidden');
                } else if (type === 'image') {
                    // Show image
                    mainDisplay.src = src;
                    mainDisplay.classList.remove('hidden');
                    videoThumbnail.classList.add('hidden');
                    videoFrame.classList.add('hidden');
                }
            }


            // Initialize first video as active
            document.querySelector('[onclick^="showMedia"]').click();
        </script>


        <script>
            $(document).ready(function() {
                const $navLinks = $('.section-link');
                const $sections = $navLinks.map(function() {
                    const href = $(this).attr('href');
                    return $(href); // Get corresponding sections
                }).get();

                // Throttle scroll events (better performance)
                let isScrolling;


                function updateActiveLink() {
                    const scrollPosition = $(window).scrollTop() + ($(window).height() /
                        3); // Adjust offset (1/3 of viewport)
                    let activeSection = null;

                    // Check sections from BOTTOM to TOP (reverse order)
                    for (let i = $sections.length - 1; i >= 0; i--) {
                        const $section = $sections[i];
                        if (!$section.length) continue;

                        const sectionTop = $section.offset().top;
                        const sectionBottom = sectionTop + $section.outerHeight();

                        if (scrollPosition >= sectionTop && scrollPosition <= sectionBottom) {
                            activeSection = $section.attr('id');
                            break; // Stop at the first matching section (bottom-up)
                        }
                    }

                    // Update active link
                    $navLinks.each(function() {
                        const $link = $(this);
                        const linkHref = $link.attr('href').substring(1); // Remove '#'

                        if (linkHref === activeSection) {
                            $link.addClass('bg-dark text-white')
                                .removeClass('text-gray-600 hover:bg-gray-200');
                        } else {
                            $link.removeClass('bg-dark text-white')
                                .addClass('text-gray-600 hover:bg-gray-200');
                        }
                    });
                }

                // Initial check & scroll listener
                $(window).on('scroll', updateActiveLink);


            });
        </script>

        <script>
            new Swiper('.swiper', {
                loop: true,
                autoplay: {
                    delay: 5000,
                    disableOnInteraction: false,
                },
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
            });
        </script>

        <script>
            function openVideoModal(source) {
                const modal = document.getElementById('videoModal');
                const iframe = document.getElementById('youtubeVideo');

                iframe.src = source;

                modal.style.display = 'flex';
                document.body.style.overflow = 'hidden';
            }

            function closeVideoModal() {
                const modal = document.getElementById('videoModal');
                const iframe = document.getElementById('youtubeVideo');

                iframe.src = '';
                modal.style.display = 'none';
                document.body.style.overflow = 'auto'; // Re-enable scrolling
            }
        </script>
        <script>
            $(document).ready(function() {
                let $descBox = $("#descriptionBox");
                let $toggleBtn = $("#toggleBtn");
                let $fade = $("#fadeEffect");

                $toggleBtn.on("click", function() {
                    if ($descBox.hasClass("max-h-96")) {
                        // Expand
                        $descBox.removeClass("max-h-96 overflow-hidden");
                        $fade.removeClass(
                            'bg-[linear-gradient(180deg,rgba(255,255,255,0)_0%,rgba(255,255,255,0.9)_50%)]  backdrop-blur-[0px]'
                        );
                        $toggleBtn.text("Show Less");
                    } else {
                        // Collapse
                        $descBox.addClass("max-h-96 overflow-hidden");
                        $fade.addClass(
                            'bg-[linear-gradient(180deg,rgba(255,255,255,0)_0%,rgba(255,255,255,0.9)_50%)]  backdrop-blur-[0px]'
                        );
                        $toggleBtn.text("Show More");
                    }
                });
            });
        </script>
        <script>
            const applyCupon = (courseId, input, couponId, mainPrice) => {
                let couponCode = $('#' + input).val().trim();

                if (!couponCode) {

                    Swal.fire({
                        icon: 'warning',
                        title: 'Oops!',
                        text: '<?php echo e(__('messages.copone_code_empty')); ?>',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        $('#' + input).focus();
                    });
                    return;
                }

                Swal.fire({
                    title: '<?php echo e(__('messages.copone_code_pr_title')); ?>',
                    text: '<?php echo e(__('messages.copone_code_pr_dsc')); ?>',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });

                $.ajax({
                    url: "<?php echo e(route('coupon.search')); ?>",
                    method: 'POST',
                    data: {
                        _token: $('meta[name="csrf-token"]').attr('content'),
                        courseId: courseId,
                        couponCode: couponCode

                    },
                    success: function(response) {
                        $('#' + input).parent().addClass('hidden')
                        $('#enroll_button_sm').removeClass('hidden')
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        });
                        $('#' + couponId).val(response.coupon_id)
                        $('#' + mainPrice).html(response.main_amount)
                        $('#modal_coupon_id').val(response.coupon_id)
                        $('#modal_total_price').html(response.main_amount)
                    },
                    error: function(xhr) {
                        $('#' + input).val('')
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: xhr.responseJSON?.message ||
                                'Something went wrong. Please try again.'
                        });
                    }
                });


            }
        </script>


        <script>
            const addCopune = (apply_wrapper, enroll_btn) => {
                $('#' + apply_wrapper).toggleClass('hidden');
                $('#' + enroll_btn).toggleClass('hidden');
            }
            const removeCouponWrapper = (apply_wrapper, enroll_btn) => {
                $('#' + apply_wrapper).toggleClass('hidden');
                $('#' + enroll_btn).toggleClass('hidden');
            }
        </script>

        <script>
            function openPaymentModal() {
                document.getElementById('paymentModal').classList.remove('hidden');
                document.getElementById('paymentModal').classList.add('flex');
            }

            function closePaymentModal() {
                document.getElementById('paymentModal').classList.add('hidden');
                document.getElementById('paymentModal').classList.remove('flex');
            }
        </script>
    <?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nexgenweb/lms.nexgenwebhub.com/resources/views/page/course/view.blade.php ENDPATH**/ ?>