<!doctype html>
<html lang="en" class="light-theme">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!--favicon-->

    <link rel="icon" href="<?php echo e(asset($websiteSetting->favicon)); ?>" type="image/png" />

    <!--plugins-->
    <link href="<?php echo e(asset('backend/assets/plugins/simplebar/css/simplebar.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('backend/assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('backend/assets/plugins/metismenu/css/metisMenu.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('backend/assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/plugins/notifications/css/lobibox.min.css')); ?>"
        rel="stylesheet" />
    
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/dropify.css')); ?>">

    <!-- loader
    <link href="<?php echo e(asset('backend/assets/css/pace.min.css')); ?>" rel="stylesheet" />
    <script src="<?php echo e(asset('backend/assets/js/pace.min.js')); ?>"></script> -->

    <!-- Bootstrap CSS -->
    <link href="<?php echo e(asset('backend/assets/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('backend/assets/css/bootstrap-extended.css')); ?>" rel="stylesheet">

    <!-- Select2 CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/select2.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/select2-custom.css')); ?>" />

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/icons.css')); ?>">



    <script src="<?php echo e(asset('backend/assets/js/jquery.min.js')); ?>"></script>

    <!-- App Styles -->
    <link href="<?php echo e(asset('backend/assets/css/app.css')); ?>" rel="stylesheet">

    

    <!-- Theme Style CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/dark-theme.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/semi-dark.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/header-colors.css')); ?>" />
    <!-- Custom Style CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/custom.css')); ?>" />

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.9.1/summernote-bs4.min.css"
        integrity="sha512-rDHV59PgRefDUbMm2lSjvf0ZhXZy3wgROFyao0JxZPGho3oOuWejq/ELx0FOZJpgaE5QovVtRN65Y3rrb7JhdQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
  
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote-lite.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote-lite.min.js"></script>


    <!-- IVIS Toast CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/ivis_toast.css')); ?>">
    <script src="<?php echo e(asset('backend/assets/js/ivis_toast.js')); ?>"></script>

    <!-- SweetAlert2 CSS -->
    <link href="<?php echo e(asset('assets/css/sweetalert2.min.css')); ?>" rel="stylesheet">

    <style>
        .dropify-wrapper .dropify-message span.file-icon:before {
            content: "";
            /* remove font glyph */
            display: inline-block;
            width: 64px;
            /* increase width */
            height: 64px;
            /* increase height */
            background-image: url("<?php echo e(asset('assets/icons/drag-drop.png')); ?>");
            background-size: contain;
            /* keeps aspect ratio */
            background-repeat: no-repeat;
            background-position: center;
            margin-left: .2em;
            margin-right: .2em;
            vertical-align: middle;
        }
    </style>


    <?php echo $__env->yieldPushContent('css'); ?>


    <title>
        Admin Dashboard
    </title>
    <style>
        .version-container {
            display: flex;
            align-items: center;
            background: linear-gradient(to right, #F8F9FA, #E9ECEF);
            padding: 5px 8px;
            border-radius: 6px;
            margin-top: 20px;
            margin-right: 10px;
            margin-left: 10px;
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.05);
            border-left: 2px solid #6C5CE7;
        }

        .version-icon {
            color: #6C5CE7;
            margin-right: 6px;
            transform: scale(0.7);
        }

        .version-text {
            display: flex;
            align-items: center;
        }

        .version-label {
            font-size: 13px;
            color: #6C757D;
            font-weight: 500;
            margin-right: 4px;
        }

        .version-number {
            font-size: 13px;
            font-weight: 600;
            color: #6C5CE7;
        }

        .sidebar-header img.logo-icon {
            max-width: 120px;
            width: 100%;
        }


        .wrapper.toggled .sidebar-header img.logo-icon {
            width: 50px;
        }


        /* Base styles */
        :root {
            --sidebar-width: 260px;
            --sidebar-width-collapsed: 206px;
        }

        td.last2 {
            grid-row-gap: 10px;
            grid-column-gap: 10px;
        }


        .order_table_pagination svg {
            width: 20px;
        }

        .d-flex.order_table_pagination.justify-content-center {
            width: 100%;
            flex-direction: column;
        }

        @media (max-width: 1440px) {
          
            .sidebar-wrapper {
                width: 200px;
            }

            .sidebar-header {
                width: 200px;
            }

            td.last2 {
                display: grid;
            }
        }

        /* Medium devices (tablets) */
        @media (max-width: 991px) {
            .wrapper {
                padding-left: 0;
            }

            .sidebar-wrapper {
                width: var(--sidebar-width);
                transform: translateX(-100%);
                transition: transform 0.3s ease-out;
            }

            .sidebar-wrapper.show {
                transform: translateX(0);
            }

            .page-wrapper {
                margin-left: 0 !important;
                width: 100%;
            }

            .my-table,
            .my-table2 {
                font-size: 14px;
            }

            .table-responsive {
                overflow-x: auto;
                -webkit-overflow-scrolling: touch;
            }
        }

        /* Extra small devices */
        @media (max-width: 575px) {
            .header-wrapper {
                padding: 0.5rem;
            }


            .card {
                margin-bottom: 0.5rem;
            }

            input.form-control.form-control-sm.tableSearchber {
                width: auto !important;
                margin-top: 10px;
            }
        }

        /* Print styles */
        @media print {

            .sidebar-wrapper,
            .header-wrapper,
            .back-to-top,
            .overlay {
                display: none !important;
            }

            .page-wrapper {
                margin: 0;
                padding: 0;
            }

            .card {
                break-inside: avoid;
            }
        }

        @media screen and (max-width: 1024px) {
            .wrapper.toggled:not(.sidebar-hovered) .sidebar-wrapper {
                width: 70px !important;
            }

            .wrapper.toggled:not(.sidebar-hovered) .sidebar-wrapper .menu-title {
                display: none;
            }

            .wrapper.toggled .page-wrapper {
                margin-left: 70px !important;
            }
        }

        .singleattibute-container {
            display: none;
        }

        .combineattibute-container {
            display: none;
        }

        /* Small devices (phones) */
        @media (max-width: 1440px) {
            .page-wrapper {
                margin-left: 200px;
            }

            .sidebar-wrapper .metismenu a .menu-title {
                font-size: 13px;
                margin-left: 8px;
            }
  .sidebar-wrapper .metismenu ul a{
                font-size: 12px;
            }
            .status-card {
                margin-bottom: 1rem;
            }

            .status-card h4 {
                font-size: 16px;
            }

            .pastel-button {
                padding: 8px;
                font-size: 12px;
                width: 100%;
                margin: 0.25rem 0;
            }

            .my-table,
            .my-table2 {
                font-size: 12px;
            }

            .my-table thead tr th,
            .my-table2 thead tr th,
            .my-table tbody tr td,
            .my-table2 tbody tr td {
                padding: 6px 4px;
            }
        }
    </style>

    <style>
        .tableSearchber {
            width: 280px !important;
        }

        @media (max-width: 991px) {
            .wrapper.toggled .sidebar-wrapper {
                left: 250px !important;
            }

            .wrapper.toggled:not(.sidebar-hovered) .sidebar-wrapper {
                width: 250px !important;
            }

            .wrapper.toggled .page-wrapper {
                margin-left: 0px !important;
            }

            .sidebar-wrapper .metismenu a {
                padding: 6px 6px;
            }

            .overlay.toggle-icon.show {

                position: fixed;
                top: 0;
                right: 0;
                bottom: 0;
                left: 0;
                background: #000;
                opacity: .6;
                z-index: 10;
                display: block;
                cursor: move;
                transition: all .2s ease-out;

            }

            .dataTable {
                width: 100% !important;
                overflow-x: scroll;
            }

            .wrapper.toggled:not(.sidebar-hovered) .sidebar-wrapper .menu-title {
                display: block;
            }


        }

        @media (max-width: 550px) {
            .dataTable {
                display: inline-block;
            }

            table#transactionsTable {
                width: 100%;
                overflow-x: scroll;
                display: inline-block;
            }
        }
        :root {
  --primary: #4F46E5;
  --primary-dark: #4338CA;
  --primary-light: #6366F1;
  --success: #10B981;
  --warning: #F59E0B;
  --danger: #EF4444;
  --dark: #1E293B;
  --light: #F1F5F9;
}

/* Primary Button */
.btn-primary {
  --bs-btn-color: #fff;
  --bs-btn-bg: var(--primary);
  --bs-btn-border-color: var(--primary);
  --bs-btn-hover-bg: var(--primary-dark);
  --bs-btn-hover-border-color: var(--primary-dark);
  --bs-btn-active-bg: var(--primary-dark);
}

/* Secondary Button */
.btn-secondary {
  --bs-btn-color: #fff;
  --bs-btn-bg: var(--primary-light);
  --bs-btn-border-color: var(--primary-light);
  --bs-btn-hover-bg: var(--primary);
  --bs-btn-hover-border-color: var(--primary);
}

/* Success Button */
.btn-success {
  --bs-btn-bg: var(--success);
  --bs-btn-border-color: var(--success);
  --bs-btn-hover-bg: #059669;
}

/* Warning */
.btn-warning {
  --bs-btn-color: #000;
  --bs-btn-bg: var(--warning);
  --bs-btn-border-color: var(--warning);
}

/* Danger */
.btn-danger {
  --bs-btn-bg: var(--danger);
  --bs-btn-border-color: var(--danger);
}

/* Dark */
.btn-dark {
  --bs-btn-bg: var(--dark);
  --bs-btn-border-color: var(--dark);
}

    </style>

</head>

<body>
    <!--wrapper-->

    <?php echo $__env->make('backend.layout.loader', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>


    <div class="wrapper">
        <!--sidebar wrapper -->
        
        <?php echo $__env->make('backend.layout.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <!--start header -->
        <?php echo $__env->make('backend.layout.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        


        <!--start page wrapper -->
        <div class="page-wrapper">
            <?php echo $__env->yieldContent('content'); ?>


        </div>

        <div id="overlay" class="overlay toggle-icon"></div>

        <!--end overlay-->
        <!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i
                class='bx bxs-up-arrow-alt'></i></a>
        <!--End Back To Top Button-->
        


        <footer class="page-footer">
            <p class="mb-0">Copyright © 2025. <?php echo e($websiteSetting->app_name); ?>. All right reserved.</p>
        </footer>
        
    </div>



    <!-- Bootstrap JS -->
    <script src="<?php echo e(asset('backend/assets/js/bootstrap.bundle.min.js')); ?>"></script>

    <!--plugins-->

    <script src="<?php echo e(asset('backend/assets/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/plugins/metismenu/js/metisMenu.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>





    <script src="<?php echo e(asset('backend/assets/plugins/peity/jquery.peity.min.js')); ?>"></script>


    <script src="<?php echo e(asset('backend/assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>






    <script>
        $(document).ready(function() {
            var table = $('#datatable_internal').DataTable();

        });
    </script>

    <script>
$('#clearCacheBtn').on('click', function(e){
     e.preventDefault();
    let url = $(this).attr('href');

 
    Swal.fire({
        title: 'Are you sure?',
        text: "This will clear and optimize your Website!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, clear it!'
    }).then((result) => {
        if (result.isConfirmed) {
            window.location= url
        }
    })
});
</script>



    <script>
        let overlay = document.getElementById('overlay');
        let toggleIcon = document.querySelector('.mobile-toggle-menu');
        let closedOverlay = document.querySelector('.toggle-icon');

        toggleIcon.addEventListener('click', function() {
            overlay.classList.toggle('show');
        });

        closedOverlay.addEventListener('click', function() {
            overlay.classList.remove('show');
        });
        overlay.addEventListener('click', function() {
            overlay.classList.remove('show');
        })
    </script>


    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>




<script>
   $('#editor').summernote({
        placeholder: 'Hello stand alone ui',
        tabsize: 2,
        height: 'auto',
        minHeight: 300,
        maxHeight:1000,
        toolbar: [
          ['style', ['style']],
          ['font', ['bold', 'underline', 'clear']],
          ['color', ['color']],
          ['para', ['ul', 'ol', 'paragraph']],
          ['table', ['table']],
          ['insert', ['link', 'picture', 'video']],
          ['view', ['fullscreen', 'codeview', 'help']]
        ]
      });
</script>





    <!--app JS-->
    <script src="<?php echo e(asset('backend/assets/js/app.js')); ?>"></script>





    <!-- Include Toastr JS -->
    
  

    <!-- SweetAlert2 JS -->
    <script src="<?php echo e(asset('backend/assets/js/sweetalert2.min.js')); ?>"></script>

    
    <script src="<?php echo e(asset('backend/assets/js/dropify.min.js')); ?>"></script>


    
    <script>
        $('.yajraDataDelete').on('click', '.deleteButton', function(e) {
            let destroyUrl = $(this).data('url');


            Swal.fire({
                title: "Are you sure to delete this Data?",
                text: "The data will be permanently deleted",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#d33",
                cancelButtonColor: "#3085d6",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        title: 'Deleting...',
                        text: 'Please wait!',
                        allowOutsideClick: false,
                        didOpen: () => {
                            Swal.showLoading();
                        }
                    });

                    $.ajax({
                        url: destroyUrl,
                        method: 'DELETE',
                        data: {
                            _token: $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(res) {
                            if (res.status == true) {
                                $('.yajraDataDelete').DataTable().ajax.reload(null, false);
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Deleted!',
                                    text: res.message || 'Data Deleted successfully.'
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error!',
                                    text: res.message || 'Something Went Wrong'
                                });
                            }
                        },
                        error: function(xhr) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error!',
                                text: xhr.responseJSON?.message ||
                                        'Delete failed. Please try again.'
                                
                            });
                        }
                    });

                }

            });
        });
    </script>

    
    <script>
        $(document).ready(function() {
            $('.deleteButton').on('click', function(e) {
                let parentId = $(this).data('parentid');
                let destroyUrl = $(this).data('url');

                Swal.fire({
                    title: "Are you sure?",
                    text: "The data will be permanently deleted!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#d33",
                    cancelButtonColor: "#3085d6",
                    confirmButtonText: "Yes, delete it!"
                }).then((result) => {
                    if (result.isConfirmed) {
                        Swal.fire({
                            title: 'Deleting...',
                            text: 'Please wait!',
                            allowOutsideClick: false,
                            didOpen: () => {
                                Swal.showLoading();
                            }
                        });
                        $.ajax({
                            url: destroyUrl,
                            method: 'DELETE',
                            data: {
                                _token: $('meta[name="csrf-token"]').attr('content'),
                            },
                            success: function(res) {
                                if (res.status == true) {
                                  $('#' + parentId).fadeOut(500);
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Deleted!',
                                        text: res.message ||
                                            'Deleted successfully.'
                                    });
                                } else {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Error!',
                                        text: res.message ||
                                            'Something Went Wrong'
                                    });
                                }
                            },
                            error: function(xhr) {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error!',
                                    text: xhr.responseJSON?.message ||
                                        'Delete failed. Please try again.'
                                });
                            }

                        });
                    }

                });
            })

        });
    </script>


    <script>
        $(document).ready(function() {
            // Initialize Dropify
            $('.dropify').dropify({
                messages: {
                    default: 'Drag and Drop or Click',
                }
            });

        })
    </script>

    <script>
        //check dark mode or light in the local storage and add into the html
        if (localStorage.getItem('theme') == 'dark') {
            document.documentElement.setAttribute('data-theme', 'dark');
        } else {
            document.documentElement.setAttribute('data-theme', 'light');
        }
    </script>


    <script>
        $(document).ready(function() {
            $('.dropify').dropify({
                messages: {
                    'default': 'Drag and drop a file here or click',
                    'replace': 'Drag and drop or click to replace',
                    'remove': 'Remove',
                    'error': 'Oops, something wrong happened.'
                }
            });
        });
    </script>



    <script>
        $(document).ready(function() {
            $('.select2').select2({
                theme: 'bootstrap-5',
                width: '100%'
            });
        });
    </script>


    <script>
        $(document).ready(function() {
            IVISToast.config({
                them: 'light',
                duration: 8000,
                position: 'top-right'
            })
            <?php if(session('ivis')): ?>
                const ivisData = <?php echo json_encode(session('ivis'), 15, 512) ?>;
                if (ivisData.type === 'success') {
                    IVISToast.success(ivisData.message);
                } else if (ivisData.type === 'error') {
                    IVISToast.error(ivisData.message);
                } else if (ivisData.type === 'warning') {
                    IVISToast.warning(ivisData.message);
                } else {
                    IVISToast.info(ivisData.message);
                }
            <?php endif; ?>
        })
    </script>

    <script>
        $(document).ready(function() {
            $('.input_name').on('input', function() {
                let slug = $(this).val().toLowerCase()
                    .trim()
                    .replace(/[^a-z0-9\s-]/g, '')
                    .replace(/\s+/g, '-')
                    .replace(/-+/g, '-');
                $('.input_slug').val(slug);
            });
        });
    </script>

    <?php echo $__env->yieldPushContent('js'); ?>


</body>


</html>
<?php /**PATH /home/nexgenweb/lms.nexgenwebhub.com/resources/views/backend/layout/app.blade.php ENDPATH**/ ?>