<?php $__env->startSection('content'); ?>
    <div class="page-content">
        <div class="row">
            <div class="col-md-12">
                <div class="card">

                    <div class="card-header bg-white">
                        <div class="row row-cols-auto g-3 justify-content-between align-items-center mb-3">
                            <form class="col d-flex align-items-center gap-3">
                                <h5 class="mb-0 fw-semibold">Filter</h5>

                                <select name="course_id" class="form-select form-select-sm select2" style="width: 400px;"
                                    id="courseSelect">
                                    <option value="" selected>Select Course</option>
                                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($course->id); ?>"
                                            <?php echo e(request('course_id') == $course->id ? 'selected' : ''); ?>><?php echo e($course->title); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <select id="module_id" name="module_id" class="form-select form-select-sm select2">
                                    <option value="" disabled> Choose Module</option>
                                    
                                    <?php if(request('module_id') && request('course_id')): ?>
                                        <?php
                                            $modules = DB::table('course_modules')
                                                ->where('course_id', request('course_id'))
                                                ->select('id', 'title')
                                                ->latest()
                                                ->get();
                                        ?>
                                        <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(request('module_id') == $module->id ? 'selected' : ''); ?>

                                                value="<?php echo e($module->id); ?>"><?php echo e($module->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>

                                </select>


                                <select name="statusSelect" class="form-select form-select-sm " style="width: 400px;"
                                    id="statusSelect">
                                    <option value="" selected>Select Status</option>
                                    <option value="1" style="background-color: rgb(222 248 251); color: #166534;">
                                        Active</option>
                                    <option value="0" style="background-color: #FEF2F2; color: #B91C1C;">Inactive
                                    </option>
                                </select>


                                <a href="<?php echo e(route('admin.module.content.index')); ?>" class="btn btn-primary btn-sm">Reset</a>
                            </form>

                            <a href="<?php echo e(route('admin.module.content.create')); ?>" class="btn btn-success px-3 btn-sm">
                                <i class="bi bi-plus-circle me-1"></i> Add New Content
                            </a>
                        </div>
                    </div>

                    <div class="card-body">
                        <table class="table table-striped my-table2 dataTable no-footer yajraDataDelete"
                            id="moduleContentTable">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th style="max-width: 200px">Title</th>
                                    <th>Course</th>
                                    <th>Module</th>
                                    <th>Type</th>
                                    <th>Content View</th>
                                    <th>Status</th>
                                    <th>Free / Paid</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- Video Modal -->
    <div class="modal fade" id="videoModal" tabindex="-1" aria-labelledby="videoModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header bg-primary text-white py-2">
                    <h5 class="modal-title text-white" id="videoModalLabel"><i class="bi bi-camera-video-fill me-2"></i>
                        Video Preview</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body p-0" id="videoModalBody">

                </div>
            </div>
        </div>
    </div>



    <script>
        function viewVideo(id) {

            var modalBody = $('#videoModalBody');


            modalBody.html(`
            <div class="ratio ratio-16x9">
                <iframe src="${id}" frameborder="0" allowfullscreen></iframe>
            </div>
        `);


            var videoModal = new bootstrap.Modal(document.getElementById('videoModal'));
            videoModal.show();
        }



        // Optional: remove video on modal close to stop playback
        $('#videoModal').on('hidden.bs.modal', function() {
            $('#videoModalBody').html('');
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready(function() {
            // -------------------------
            // Course → Module AJAX
            // -------------------------
            $('#courseSelect').on('change', function() {
                let courseId = $(this).val();
                let moduleSelect = $('#module_id');

                if (courseId) {
                    let url = "<?php echo e(route('admin.module.get', ':id')); ?>";
                    url = url.replace(':id', courseId);


                    $.ajax({
                        url: url,
                        type: "GET",
                        success: function(res) {
                            moduleSelect.empty().append(
                                '<option value="" disabled selected>Choose Module</option>'
                            );
                            if (res.length > 0) {
                                $.each(res, function(key, module) {
                                    moduleSelect.append('<option value="' + module.id +
                                        '">' + module.title + '</option>');
                                });

                            } else {
                                moduleSelect.append(
                                    '<option value="" disabled >No Module have This Course</option>'
                                );
                            }
                        },
                        error: function() {
                            Swal.fire({
                                icon: 'error',
                                title: 'Oops...',
                                text: 'Something went wrong while fetching modules!'
                            });
                        },

                    });
                }
            });


        });
    </script>



    <script>
        $(document).ready(function() {


            let table = $('#moduleContentTable').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 25,
                ajax: {
                    url: "<?php echo e(route('admin.module.content.index')); ?>",
                    data: function(d) {
                        d.course_id = $('#courseSelect').val();
                        d.module_id = $('#module_id').val();
                        d.status = $('#statusSelect').val();
                    }
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    }, // <- important
                    {
                        data: 'title',
                        name: 'title'
                    },
                    {
                        data: 'course_title',
                        name: 'course_title'
                    },
                    {
                        data: 'module_title',
                        name: 'module_title'
                    },

                    {
                        data: 'content_type',
                        name: 'content_type'
                    },
                    {
                        data: 'content_view',
                        name: 'content_view'
                    },
                    {
                        data: 'status',
                        name: 'status',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'is_free',
                        name: 'is_free',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

            $('#courseSelect, #module_id, #statusSelect').change(function() {
                table.ajax.reload();
            });

        });


        function updateStatus(el) {
            var status = el.value;
            var id = el.getAttribute('data-id');

            Swal.fire({
                title: 'Are you sure?',
                html: 'This action will update the status to ' + (el.value == 1 ?
                    '<strong style="color:green">Active</strong>' :
                    '<strong style="color:red">Inactive</strong>') + '.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, update it!',
                cancelButtonText: 'No, cancel'
            }).then((result) => {
                if (result.isConfirmed) {

                    // Confirm করলে loader দেখাবে
                    Swal.fire({
                        title: 'Updating...',
                        text: 'Please wait while the status is being updated.',
                        allowOutsideClick: false,
                        didOpen: () => {
                            Swal.showLoading();
                        }
                    });

                    $.ajax({
                        url: "<?php echo e(route('admin.module.content.update-status')); ?>",
                        method: 'PATCH',
                        data: {
                            _token: "<?php echo e(csrf_token()); ?>",
                            id: id,
                            status: status
                        },
                        success: function(response) {
                            Swal.close();
                            if (response.status) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Success!',
                                    text: response.message,
                                    timer: 4000,
                                    showConfirmButton: true
                                });

                                // Style update
                                if (status == 1) {
                                    el.style.backgroundColor = 'rgb(222 248 251)';
                                    el.style.color = '#166534';
                                } else {
                                    el.style.backgroundColor = '#FEF2F2';
                                    el.style.color = '#B91C1C';
                                }
                            }
                        },
                        error: function(xhr) {
                            Swal.close();
                            Swal.fire({
                                icon: 'error',
                                title: 'Error!',
                                text: xhr.responseJSON?.message ||
                                    'Something Went Wrong'
                            });
                        }
                    });
                } else {
                    el.value = (status == "1") ? "0" : "1";
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nexgenweb/lms.nexgenwebhub.com/resources/views/backend/page/module-content/index.blade.php ENDPATH**/ ?>